/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.task;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import org.flowable.rest.service.api.engine.EventResponse;
import org.flowable.rest.service.api.runtime.task.TaskBaseResource;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Tasks"}, description="Manage Tasks", authorizations={@Authorization(value="basicAuth")})
public class TaskEventCollectionResource
extends TaskBaseResource {
    @ApiOperation(value="List events for a task", nickname="listTaskEvents", tags={"Tasks"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the task was found and the events are returned."), @ApiResponse(code=404, message="Indicates the requested task was not found.")})
    @GetMapping(value={"/runtime/tasks/{taskId}/events"}, produces={"application/json"})
    public List<EventResponse> getEvents(@ApiParam(name="taskId") @PathVariable String taskId) {
        HistoricTaskInstance task = this.getHistoricTaskFromRequest(taskId);
        return this.restResponseFactory.createEventResponseList(this.taskService.getTaskEvents(task.getId()));
    }
}

