/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.engine.runtime.Execution;
import org.flowable.rest.service.api.engine.variable.RestVariable;
import org.flowable.rest.service.api.runtime.process.BaseExecutionVariableResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class BaseVariableCollectionResource
extends BaseExecutionVariableResource {
    @Autowired
    protected ObjectMapper objectMapper;

    public BaseVariableCollectionResource(int variableType) {
        super(variableType);
    }

    protected List<RestVariable> processVariables(Execution execution, String scope) {
        Map<String, RestVariable> variableMap = new HashMap<String, RestVariable>();
        RestVariable.RestVariableScope variableScope = RestVariable.getScopeFromString(scope);
        if (variableScope == null) {
            this.addLocalVariables(execution, variableMap);
            this.addGlobalVariables(execution, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.GLOBAL) {
            this.addGlobalVariables(execution, variableMap);
        } else if (variableScope == RestVariable.RestVariableScope.LOCAL) {
            this.addLocalVariables(execution, variableMap);
        }
        if (this.restApiInterceptor != null) {
            variableMap = this.restApiInterceptor.accessExecutionVariables(execution, variableMap);
        }
        ArrayList<RestVariable> result = new ArrayList<RestVariable>(variableMap.values());
        return result;
    }

    public void deleteAllLocalVariables(Execution execution) {
        Set<String> currentVariables = this.runtimeService.getVariablesLocal(execution.getId()).keySet();
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.deleteExecutionVariables(execution, currentVariables, RestVariable.RestVariableScope.LOCAL);
        }
        this.runtimeService.removeVariablesLocal(execution.getId(), currentVariables);
    }

    protected Object createExecutionVariable(Execution execution, boolean override, HttpServletRequest request, HttpServletResponse response) {
        Object result = null;
        if (request instanceof MultipartHttpServletRequest) {
            result = this.setBinaryVariable((MultipartHttpServletRequest)request, execution, true);
        } else {
            ArrayList<RestVariable> inputVariables = new ArrayList<RestVariable>();
            ArrayList<RestVariable> resultVariables = new ArrayList<RestVariable>();
            result = resultVariables;
            try {
                List variableObjects = (List)this.objectMapper.readValue((InputStream)request.getInputStream(), List.class);
                for (Object restObject : variableObjects) {
                    RestVariable restVariable = (RestVariable)((Object)this.objectMapper.convertValue(restObject, RestVariable.class));
                    inputVariables.add(restVariable);
                }
            }
            catch (Exception e) {
                throw new FlowableIllegalArgumentException("Failed to serialize to a RestVariable instance", (Throwable)e);
            }
            if (inputVariables == null || inputVariables.size() == 0) {
                throw new FlowableIllegalArgumentException("Request did not contain a list of variables to create.");
            }
            RestVariable.RestVariableScope sharedScope = null;
            RestVariable.RestVariableScope varScope = null;
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            for (RestVariable var : inputVariables) {
                varScope = var.getVariableScope();
                if (var.getName() == null) {
                    throw new FlowableIllegalArgumentException("Variable name is required");
                }
                if (varScope == null) {
                    varScope = RestVariable.RestVariableScope.LOCAL;
                }
                if (sharedScope == null) {
                    sharedScope = varScope;
                }
                if (varScope != sharedScope) {
                    throw new FlowableIllegalArgumentException("Only allowed to update multiple variables in the same scope.");
                }
                if (!override && this.hasVariableOnScope(execution, var.getName(), varScope)) {
                    throw new FlowableConflictException("Variable '" + var.getName() + "' is already present on execution '" + execution.getId() + "'.");
                }
                Object actualVariableValue = this.restResponseFactory.getVariableValue(var);
                variablesToSet.put(var.getName(), actualVariableValue);
            }
            if (!variablesToSet.isEmpty()) {
                Map setVariables;
                if (this.restApiInterceptor != null) {
                    this.restApiInterceptor.createExecutionVariables(execution, variablesToSet, sharedScope);
                }
                if (sharedScope == RestVariable.RestVariableScope.LOCAL) {
                    this.runtimeService.setVariablesLocal(execution.getId(), variablesToSet);
                    setVariables = this.runtimeService.getVariablesLocal(execution.getId(), variablesToSet.keySet());
                } else if (execution.getParentId() != null) {
                    this.runtimeService.setVariables(execution.getParentId(), variablesToSet);
                    setVariables = this.runtimeService.getVariables(execution.getParentId(), variablesToSet.keySet());
                } else {
                    throw new FlowableIllegalArgumentException("Cannot set global variables on execution '" + execution.getId() + "', task is not part of process.");
                }
                for (RestVariable inputVariable : inputVariables) {
                    String variableName = inputVariable.getName();
                    Object variableValue = setVariables.get(variableName);
                    resultVariables.add(this.restResponseFactory.createRestVariable(variableName, variableValue, varScope, execution.getId(), this.variableType, false));
                }
            }
        }
        response.setStatus(HttpStatus.CREATED.value());
        return result;
    }

    protected void addGlobalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawVariables = this.runtimeService.getVariables(execution.getId());
        List<RestVariable> globalVariables = this.restResponseFactory.createRestVariables(rawVariables, execution.getId(), this.variableType, RestVariable.RestVariableScope.GLOBAL);
        for (RestVariable var : globalVariables) {
            if (variableMap.containsKey(var.getName())) continue;
            variableMap.put(var.getName(), var);
        }
    }

    protected void addLocalVariables(Execution execution, Map<String, RestVariable> variableMap) {
        Map rawLocalvariables = this.runtimeService.getVariablesLocal(execution.getId());
        List<RestVariable> localVariables = this.restResponseFactory.createRestVariables(rawLocalvariables, execution.getId(), this.variableType, RestVariable.RestVariableScope.LOCAL);
        for (RestVariable var : localVariables) {
            variableMap.put(var.getName(), var);
        }
    }
}

