/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.runtime.process;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Map;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceBaseResource;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceQueryRequest;
import org.flowable.rest.service.api.runtime.process.ActivityInstanceResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Activity Instances"}, description="Manage Activity Instances", authorizations={@Authorization(value="basicAuth")})
@RestController
public class ActivityInstanceCollectionResource
extends ActivityInstanceBaseResource {
    @ApiOperation(value="List activity instances", tags={"History"}, nickname="listActivityInstances")
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates that activity instances could be queried."), @ApiResponse(code=400, message="Indicates an parameter was passed in the wrong format. The status-message contains additional information.")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="activityId", dataType="string", value="An id of the activity instance.", paramType="query"), @ApiImplicitParam(name="activityInstanceId", dataType="string", value="An id of the activity instance.", paramType="query"), @ApiImplicitParam(name="activityName", dataType="string", value="The name of the activity instance.", paramType="query"), @ApiImplicitParam(name="activityType", dataType="string", value="The element type of the activity instance.", paramType="query"), @ApiImplicitParam(name="executionId", dataType="string", value="The execution id of the activity instance.", paramType="query"), @ApiImplicitParam(name="finished", dataType="boolean", value="Indication if the activity instance is finished.", paramType="query"), @ApiImplicitParam(name="taskAssignee", dataType="string", value="The assignee of the activity instance.", paramType="query"), @ApiImplicitParam(name="processInstanceId", dataType="string", value="The process instance id of the activity instance.", paramType="query"), @ApiImplicitParam(name="processDefinitionId", dataType="string", value="The process definition id of the activity instance.", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return instances with the given tenantId.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return instances with a tenantId like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns instances without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query")})
    @GetMapping(value={"/runtime/activity-instances"}, produces={"application/json"})
    public DataResponse<ActivityInstanceResponse> getActivityInstances(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        ActivityInstanceQueryRequest query = new ActivityInstanceQueryRequest();
        if (allRequestParams.get("activityId") != null) {
            query.setActivityId(allRequestParams.get("activityId"));
        }
        if (allRequestParams.get("activityInstanceId") != null) {
            query.setActivityInstanceId(allRequestParams.get("activityInstanceId"));
        }
        if (allRequestParams.get("activityName") != null) {
            query.setActivityName(allRequestParams.get("activityName"));
        }
        if (allRequestParams.get("activityType") != null) {
            query.setActivityType(allRequestParams.get("activityType"));
        }
        if (allRequestParams.get("executionId") != null) {
            query.setExecutionId(allRequestParams.get("executionId"));
        }
        if (allRequestParams.get("finished") != null) {
            query.setFinished(Boolean.valueOf(allRequestParams.get("finished")));
        }
        if (allRequestParams.get("taskAssignee") != null) {
            query.setTaskAssignee(allRequestParams.get("taskAssignee"));
        }
        if (allRequestParams.get("processInstanceId") != null) {
            query.setProcessInstanceId(allRequestParams.get("processInstanceId"));
        }
        if (allRequestParams.get("processDefinitionId") != null) {
            query.setProcessDefinitionId(allRequestParams.get("processDefinitionId"));
        }
        if (allRequestParams.get("tenantId") != null) {
            query.setTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.get("tenantIdLike") != null) {
            query.setTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.get("withoutTenantId") != null) {
            query.setWithoutTenantId(Boolean.valueOf(allRequestParams.get("withoutTenantId")));
        }
        return this.getQueryResponse(query, allRequestParams);
    }
}

