/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.rest.service.api.management;

import org.flowable.batch.api.BatchPart;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.engine.ManagementService;
import org.flowable.rest.service.api.BpmnRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class BatchPartBaseResource {
    @Autowired
    protected ManagementService managementService;
    @Autowired(required=false)
    protected BpmnRestApiInterceptor restApiInterceptor;

    protected BatchPart getBatchPartById(String batchPartId) {
        BatchPart batchPart = this.managementService.getBatchPart(batchPartId);
        this.validateBatchPart(batchPart, batchPartId);
        return batchPart;
    }

    protected void validateBatchPart(BatchPart batchPart, String batchPartId) {
        if (batchPart == null) {
            throw new FlowableObjectNotFoundException("Could not find a batch part with id '" + batchPartId + "'.", BatchPart.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessBatchPartInfoById(batchPart);
        }
    }
}

