/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Interface;
import org.flowable.bpmn.model.Operation;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SendTask;
import org.flowable.bpmn.model.TaskWithFieldExtensions;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.impl.ExternalInvocationTaskValidator;

public class SendTaskValidator
extends ExternalInvocationTaskValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sendTasks = process.findFlowElementsOfType(SendTask.class);
        for (SendTask sendTask : sendTasks) {
            if (StringUtils.isEmpty((CharSequence)sendTask.getType()) && !"##WebService".equalsIgnoreCase(sendTask.getImplementationType())) {
                this.addError(errors, "flowable-sendtask-invalid-implementation", process, (BaseElement)sendTask, "One of the attributes 'type' or 'operation' is mandatory on sendTask");
            }
            if (StringUtils.isNotEmpty((CharSequence)sendTask.getType())) {
                if (!("mail".equalsIgnoreCase(sendTask.getType()) || "mule".equalsIgnoreCase(sendTask.getType()) || "camel".equalsIgnoreCase(sendTask.getType()))) {
                    this.addError(errors, "flowable-sendtask-invalid-type", process, (BaseElement)sendTask, "Invalid or unsupported type for send task");
                }
                if ("mail".equalsIgnoreCase(sendTask.getType())) {
                    this.validateFieldDeclarationsForEmail(process, (TaskWithFieldExtensions)sendTask, sendTask.getFieldExtensions(), errors);
                }
            }
            this.verifyWebservice(bpmnModel, process, sendTask, errors);
        }
    }

    protected void verifyWebservice(BpmnModel bpmnModel, Process process, SendTask sendTask, List<ValidationError> errors) {
        if ("##WebService".equalsIgnoreCase(sendTask.getImplementationType()) && StringUtils.isNotEmpty((CharSequence)sendTask.getOperationRef())) {
            boolean operationFound = false;
            if (bpmnModel.getInterfaces() != null && !bpmnModel.getInterfaces().isEmpty()) {
                block0: for (Interface bpmnInterface : bpmnModel.getInterfaces()) {
                    if (bpmnInterface.getOperations() == null || bpmnInterface.getOperations().isEmpty()) continue;
                    for (Operation operation : bpmnInterface.getOperations()) {
                        if (operation.getId() == null || !operation.getId().equals(sendTask.getOperationRef())) continue;
                        operationFound = true;
                        continue block0;
                    }
                }
            }
            if (!operationFound) {
                this.addError(errors, "flowable-send-webservice-invalid-operation-ref", process, (BaseElement)sendTask, "Invalid operation reference for send task");
            }
        }
    }
}

