/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service;

import java.util.HashMap;
import java.util.Map;
import org.flowable.job.api.ExternalWorkerJob;
import org.flowable.job.api.Job;
import org.flowable.job.service.InternalJobManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public abstract class ScopeAwareInternalJobManager
implements InternalJobManager {
    protected Map<String, InternalJobManager> internalJobManagerByScopeType;

    @Override
    public void registerScopedInternalJobManager(String scopeType, InternalJobManager internalJobManager) {
        if (this.internalJobManagerByScopeType == null) {
            this.internalJobManagerByScopeType = new HashMap<String, InternalJobManager>();
        }
        this.internalJobManagerByScopeType.put(scopeType, internalJobManager);
    }

    @Override
    public final VariableScope resolveVariableScope(Job job) {
        InternalJobManager internalJobManager = this.findInternalJobManager(job);
        if (internalJobManager == null) {
            return this.resolveVariableScopeInternal(job);
        }
        return internalJobManager.resolveVariableScope(job);
    }

    protected abstract VariableScope resolveVariableScopeInternal(Job var1);

    @Override
    public Map<String, Object> resolveVariablesForExternalWorkerJob(ExternalWorkerJob job) {
        InternalJobManager internalJobManager = this.findInternalJobManager((Job)job);
        if (internalJobManager == null) {
            return this.resolveVariablesForExternalWorkerJobInternal(job);
        }
        return internalJobManager.resolveVariablesForExternalWorkerJob(job);
    }

    protected abstract Map<String, Object> resolveVariablesForExternalWorkerJobInternal(ExternalWorkerJob var1);

    @Override
    public final boolean handleJobInsert(Job job) {
        InternalJobManager internalJobManager = this.findInternalJobManager(job);
        if (internalJobManager == null) {
            return this.handleJobInsertInternal(job);
        }
        return internalJobManager.handleJobInsert(job);
    }

    protected abstract boolean handleJobInsertInternal(Job var1);

    @Override
    public final void handleJobDelete(Job job) {
        InternalJobManager internalJobManager = this.findInternalJobManager(job);
        if (internalJobManager == null) {
            this.handleJobDeleteInternal(job);
        } else {
            internalJobManager.handleJobDelete(job);
        }
    }

    protected abstract void handleJobDeleteInternal(Job var1);

    @Override
    public final void lockJobScope(Job job) {
        InternalJobManager internalJobManager = this.findInternalJobManager(job);
        if (internalJobManager == null) {
            this.lockJobScopeInternal(job);
        } else {
            internalJobManager.lockJobScope(job);
        }
    }

    protected abstract void lockJobScopeInternal(Job var1);

    @Override
    public final void clearJobScopeLock(Job job) {
        InternalJobManager internalJobManager = this.findInternalJobManager(job);
        if (internalJobManager == null) {
            this.clearJobScopeLockInternal(job);
        } else {
            internalJobManager.clearJobScopeLock(job);
        }
    }

    protected abstract void clearJobScopeLockInternal(Job var1);

    @Override
    public final void preTimerJobDelete(JobEntity jobEntity, VariableScope variableScope) {
        InternalJobManager internalJobManager = this.findInternalJobManager(jobEntity);
        if (internalJobManager == null) {
            this.preTimerJobDeleteInternal(jobEntity, variableScope);
        } else {
            internalJobManager.preTimerJobDelete(jobEntity, variableScope);
        }
    }

    protected abstract void preTimerJobDeleteInternal(JobEntity var1, VariableScope var2);

    @Override
    public final void preRepeatedTimerSchedule(TimerJobEntity timerJobEntity, VariableScope variableScope) {
        InternalJobManager internalJobManager = this.findInternalJobManager(timerJobEntity);
        if (internalJobManager == null) {
            this.preRepeatedTimerScheduleInternal(timerJobEntity, variableScope);
        } else {
            internalJobManager.preRepeatedTimerSchedule(timerJobEntity, variableScope);
        }
    }

    protected abstract void preRepeatedTimerScheduleInternal(TimerJobEntity var1, VariableScope var2);

    protected InternalJobManager findInternalJobManager(Job job) {
        if (this.internalJobManagerByScopeType == null || this.internalJobManagerByScopeType.isEmpty()) {
            return null;
        }
        String scopeType = job.getScopeType();
        if (scopeType == null && job.getProcessInstanceId() != null) {
            scopeType = "bpmn";
        }
        return this.internalJobManagerByScopeType.get(scopeType);
    }
}

