/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityManager;

public class UnacquireAllExternalWorkerJobsForWorkerCmd
implements Command<Void> {
    protected final String workerId;
    protected final String tenantId;
    protected final JobServiceConfiguration jobServiceConfiguration;

    public UnacquireAllExternalWorkerJobsForWorkerCmd(String workerId, String tenantId, JobServiceConfiguration jobServiceConfiguration) {
        this.workerId = workerId;
        this.tenantId = tenantId;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        if (StringUtils.isEmpty((CharSequence)this.workerId)) {
            throw new FlowableIllegalArgumentException("worker id must not be empty");
        }
        ExternalWorkerJobEntityManager externalWorkerJobEntityManager = this.jobServiceConfiguration.getExternalWorkerJobEntityManager();
        List<ExternalWorkerJobEntity> jobEntities = externalWorkerJobEntityManager.findJobsByWorkerId(this.workerId);
        if (!jobEntities.isEmpty()) {
            if (StringUtils.isNotEmpty((CharSequence)this.tenantId)) {
                for (ExternalWorkerJobEntity externalWorkerJob : jobEntities) {
                    if (this.tenantId.equals(externalWorkerJob.getTenantId())) continue;
                    throw new FlowableIllegalArgumentException("provided worker id has external worker jobs from different tenant.");
                }
            }
            externalWorkerJobEntityManager.bulkUpdateJobLockWithoutRevisionCheck(jobEntities, null, null);
        }
        return null;
    }
}

