/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.job.service.impl.asyncexecutor.AcquiredJobEntities;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.cmd.AcquireJobsCmd;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireAsyncJobsDueRunnable
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AcquireAsyncJobsDueRunnable.class);
    protected String name;
    protected final AsyncExecutor asyncExecutor;
    protected final JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager;
    protected volatile boolean isInterrupted;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireAsyncJobsDueRunnable(String name, AsyncExecutor asyncExecutor, JobInfoEntityManager<? extends JobInfoEntity> jobEntityManager) {
        this.name = name;
        this.asyncExecutor = asyncExecutor;
        this.jobEntityManager = jobEntityManager;
    }

    @Override
    public synchronized void run() {
        LOGGER.info("starting to acquire async jobs due");
        Thread.currentThread().setName(this.name);
        CommandExecutor commandExecutor = this.asyncExecutor.getJobServiceConfiguration().getCommandExecutor();
        while (!this.isInterrupted) {
            long millisToWait;
            int remainingCapacity = this.asyncExecutor.getRemainingCapacity();
            if (remainingCapacity > 0) {
                millisToWait = this.acquireAndExecuteJobs(commandExecutor, remainingCapacity);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("acquired and queued new jobs for engine {}; sleeping for {} ms", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)millisToWait);
                }
            } else {
                millisToWait = this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("queue is full for engine {}; sleeping for {} ms", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)millisToWait);
                }
            }
            if (millisToWait <= 0L) continue;
            this.sleep(millisToWait);
        }
        LOGGER.info("stopped async job due acquisition for engine {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
    }

    protected long acquireAndExecuteJobs(CommandExecutor commandExecutor, int remainingCapacity) {
        try {
            AcquiredJobEntities acquiredJobs = (AcquiredJobEntities)commandExecutor.execute((Command)new AcquireJobsCmd(this.asyncExecutor, remainingCapacity, this.jobEntityManager));
            List<JobInfoEntity> rejectedJobs = this.offerJobs(acquiredJobs);
            LOGGER.debug("Jobs acquired: {}, rejected: {}, for engine {}", new Object[]{acquiredJobs.size(), rejectedJobs.size(), this.asyncExecutor.getJobServiceConfiguration().getEngineName()});
            if (rejectedJobs.size() > 0) {
                return this.asyncExecutor.getDefaultQueueSizeFullWaitTimeInMillis();
            }
            if (acquiredJobs.size() >= this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()) {
                return 0L;
            }
        }
        catch (FlowableOptimisticLockingException optimisticLockingException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Optimistic locking exception during async job acquisition. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire a due async job, which already was acquired by another async executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple async executor acquisition threads running against the same database. for engine {}. Exception message: {}", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable e) {
            LOGGER.error("exception for engine {} during async job acquisition: {}", new Object[]{this.asyncExecutor.getJobServiceConfiguration().getEngineName(), e.getMessage(), e});
        }
        return this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    protected List<JobInfoEntity> offerJobs(AcquiredJobEntities acquiredJobs) {
        ArrayList<JobInfoEntity> rejected = new ArrayList<JobInfoEntity>();
        for (JobInfoEntity job : acquiredJobs.getJobs()) {
            boolean jobSuccessFullyOffered = this.asyncExecutor.executeAsyncJob(job);
            if (jobSuccessFullyOffered) continue;
            rejected.add(job);
        }
        return rejected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long millisToWait) {
        if (millisToWait > 0L) {
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, thread sleeping for {} millis", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName(), (Object)millisToWait);
                }
                Object object = this.MONITOR;
                synchronized (object) {
                    if (!this.isInterrupted) {
                        this.isWaiting.set(true);
                        this.MONITOR.wait(millisToWait);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, thread woke up", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("async job acquisition for engine {}, wait interrupted", (Object)this.asyncExecutor.getJobServiceConfiguration().getEngineName());
                }
            }
            finally {
                this.isWaiting.set(false);
            }
        }
    }
}

