/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.group;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.rest.exception.FlowableConflictException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.UserQuery;
import org.flowable.idm.rest.service.api.group.BaseGroupResource;
import org.flowable.idm.rest.service.api.group.MembershipRequest;
import org.flowable.idm.rest.service.api.group.MembershipResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Groups"}, description="Manage Groups", authorizations={@Authorization(value="basicAuth")})
public class GroupMembershipCollectionResource
extends BaseGroupResource {
    @ApiOperation(value="Add a member to a group", tags={"Groups"}, code=201)
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the group was found and the member has been added."), @ApiResponse(code=400, message="Indicates the userId was not included in the request body."), @ApiResponse(code=404, message="Indicates the requested group was not found."), @ApiResponse(code=409, message="Indicates the requested user is already a member of the group.")})
    @PostMapping(value={"/groups/{groupId}/members"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public MembershipResponse createMembership(@ApiParam(name="groupId") @PathVariable String groupId, @RequestBody MembershipRequest memberShip) {
        Group group = this.getGroupFromRequest(groupId);
        if (memberShip.getUserId() == null) {
            throw new FlowableIllegalArgumentException("UserId cannot be null.");
        }
        if (((UserQuery)((UserQuery)this.identityService.createUserQuery().memberOfGroup(group.getId())).userId(memberShip.getUserId())).count() > 0L) {
            throw new FlowableConflictException("User '" + memberShip.getUserId() + "' is already part of group '" + group.getId() + "'.");
        }
        this.identityService.createMembership(memberShip.getUserId(), group.getId());
        return this.restResponseFactory.createMembershipResponse(memberShip.getUserId(), group.getId());
    }
}

