/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.rest.service.api.group;

import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.rest.service.api.IdmRestApiInterceptor;
import org.flowable.idm.rest.service.api.IdmRestResponseFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseGroupResource {
    @Autowired
    protected IdmRestResponseFactory restResponseFactory;
    @Autowired
    protected IdmIdentityService identityService;
    @Autowired(required=false)
    protected IdmRestApiInterceptor restApiInterceptor;

    protected Group getGroupFromRequest(String groupId) {
        Group group = (Group)this.identityService.createGroupQuery().groupId(groupId).singleResult();
        if (group == null) {
            throw new FlowableObjectNotFoundException("Could not find a group with id '" + groupId + "'.", Group.class);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessGroupInfoById(group);
        }
        return group;
    }
}

