/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.http.common.impl;

import java.time.Duration;
import java.util.Objects;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.http.common.api.client.FlowableHttpClient;
import org.flowable.http.common.impl.apache.ApacheHttpComponentsFlowableHttpClient;
import org.flowable.http.common.impl.apache.client5.ApacheHttpComponents5FlowableHttpClient;
import org.flowable.http.common.impl.spring.reactive.SpringWebClientFlowableHttpClient;

public class HttpClientConfig {
    protected static final boolean isApacheHttpComponentsPresent;
    protected static final boolean isApacheHttpComponents5Present;
    protected static final boolean isSpringWebClientPresent;
    protected static final boolean isReactorHttpClientPresent;
    protected int connectTimeout = 5000;
    protected int socketTimeout = 5000;
    protected int connectionRequestTimeout = 5000;
    protected int requestRetryLimit = 3;
    protected boolean disableCertVerify;
    protected boolean useSystemProperties = false;
    protected FlowableHttpClient httpClient;
    protected Runnable closeRunnable;
    protected boolean defaultParallelInSameTransaction = false;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getRequestRetryLimit() {
        return this.requestRetryLimit;
    }

    public void setRequestRetryLimit(int requestRetryLimit) {
        this.requestRetryLimit = requestRetryLimit;
    }

    public boolean isDisableCertVerify() {
        return this.disableCertVerify;
    }

    public void setDisableCertVerify(boolean disableCertVerify) {
        this.disableCertVerify = disableCertVerify;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void merge(HttpClientConfig other) {
        if (this.connectTimeout != other.getConnectTimeout()) {
            this.setConnectTimeout(other.getConnectTimeout());
        }
        if (this.socketTimeout != other.getSocketTimeout()) {
            this.setSocketTimeout(other.getSocketTimeout());
        }
        if (this.connectionRequestTimeout != other.getConnectionRequestTimeout()) {
            this.setConnectionRequestTimeout(other.getConnectionRequestTimeout());
        }
        if (this.requestRetryLimit != other.getRequestRetryLimit()) {
            this.setRequestRetryLimit(other.getRequestRetryLimit());
        }
        if (this.disableCertVerify != other.isDisableCertVerify()) {
            this.setDisableCertVerify(other.isDisableCertVerify());
        }
        if (this.useSystemProperties != other.isUseSystemProperties()) {
            this.setUseSystemProperties(other.isUseSystemProperties());
        }
        if (!Objects.equals(this.httpClient, other.getHttpClient())) {
            this.setHttpClient(other.getHttpClient());
        }
        if (this.defaultParallelInSameTransaction != other.isDefaultParallelInSameTransaction()) {
            this.setDefaultParallelInSameTransaction(other.isDefaultParallelInSameTransaction());
        }
    }

    public void setConnectionRequestTimeout(Duration connectionRequestTimeout) {
        this.setConnectionRequestTimeout(Math.toIntExact(connectionRequestTimeout.toMillis()));
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
    }

    public void setSocketTimeout(Duration socketTimeout) {
        this.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
    }

    public FlowableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(FlowableHttpClient httpClient) {
        this.httpClient = httpClient;
        this.closeRunnable = null;
    }

    public FlowableHttpClient determineHttpClient() {
        if (this.httpClient != null) {
            return this.httpClient;
        }
        if (isApacheHttpComponentsPresent) {
            this.httpClient = new ApacheHttpComponentsFlowableHttpClient(this);
            return this.httpClient;
        }
        if (isSpringWebClientPresent && isReactorHttpClientPresent) {
            this.httpClient = new SpringWebClientFlowableHttpClient(this);
            return this.httpClient;
        }
        if (isApacheHttpComponents5Present) {
            ApacheHttpComponents5FlowableHttpClient httpClient = new ApacheHttpComponents5FlowableHttpClient(this);
            this.httpClient = httpClient;
            this.closeRunnable = httpClient::close;
            return this.httpClient;
        }
        throw new FlowableException("Failed to determine FlowableHttpClient");
    }

    public boolean isDefaultParallelInSameTransaction() {
        return this.defaultParallelInSameTransaction;
    }

    public void setDefaultParallelInSameTransaction(boolean defaultParallelInSameTransaction) {
        this.defaultParallelInSameTransaction = defaultParallelInSameTransaction;
    }

    public void close() {
        if (this.closeRunnable != null) {
            this.closeRunnable.run();
        }
    }

    static {
        ClassLoader loader = HttpClientConfig.class.getClassLoader();
        boolean httpClientBuilderPresent = false;
        try {
            Class.forName("org.apache.http.impl.client.HttpClientBuilder", false, loader);
            httpClientBuilderPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isApacheHttpComponentsPresent = httpClientBuilderPresent;
        boolean httpClient5BuilderPresent = false;
        try {
            Class.forName("org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder", false, loader);
            httpClient5BuilderPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isApacheHttpComponents5Present = httpClient5BuilderPresent;
        boolean springWebClientBuilderPresent = false;
        try {
            Class.forName("org.springframework.web.reactive.function.client.WebClient", false, loader);
            springWebClientBuilderPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isSpringWebClientPresent = springWebClientBuilderPresent;
        boolean reactorHttpClientPresent = false;
        try {
            Class.forName("reactor.netty.http.client.HttpClient", false, loader);
            reactorHttpClientPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        isReactorHttpClientPresent = reactorHttpClientPresent;
    }
}

