/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.eventregistry.api.EventDeployment;
import org.flowable.eventregistry.api.EventDeploymentQuery;
import org.flowable.eventregistry.impl.EventDeploymentQueryImpl;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventResourceEntity;
import org.flowable.eventregistry.impl.repository.EventDeploymentBuilderImpl;
import org.flowable.eventregistry.impl.util.CommandContextUtil;

public class DeployCmd<T>
implements Command<EventDeployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected EventDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(EventDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public EventDeployment execute(CommandContext commandContext) {
        EventDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        EventRegistryEngineConfiguration eventRegistryConfiguration = CommandContextUtil.getEventRegistryConfiguration(commandContext);
        deployment.setDeploymentTime(eventRegistryConfiguration.getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList<EventDeployment> existingDeployments = new ArrayList<EventDeployment>();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = ((EventDeploymentQuery)new EventDeploymentQueryImpl(eventRegistryConfiguration.getCommandExecutor()).deploymentName(deployment.getName()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add((EventDeployment)deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((EventDeploymentQuery)eventRegistryConfiguration.getEventRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            if (!existingDeployments.isEmpty()) {
                EventDeploymentEntity existingDeployment = (EventDeploymentEntity)existingDeployments.get(0);
                HashMap<String, EventResourceEntity> resourceMap = new HashMap<String, EventResourceEntity>();
                List<EventResourceEntity> resourceList = eventRegistryConfiguration.getResourceEntityManager().findResourcesByDeploymentId(existingDeployment.getId());
                for (EventResourceEntity resourceEntity : resourceList) {
                    resourceMap.put(resourceEntity.getName(), resourceEntity);
                }
                existingDeployment.setResources(resourceMap);
                if (!this.deploymentsDiffer(deployment, existingDeployment)) {
                    return existingDeployment;
                }
            }
        }
        deployment.setNew(true);
        eventRegistryConfiguration.getDeploymentEntityManager().insert(deployment);
        if (StringUtils.isEmpty((CharSequence)deployment.getParentDeploymentId())) {
            deployment.setParentDeploymentId(deployment.getId());
        }
        eventRegistryConfiguration.getDeploymentManager().deploy(deployment);
        return deployment;
    }

    protected boolean deploymentsDiffer(EventDeploymentEntity deployment, EventDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, EventResourceEntity> resources = deployment.getResources();
        Map<String, EventResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            EventResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            EventResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

