/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.test;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.db.SchemaManager;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.test.EnsureCleanDb;
import org.flowable.common.engine.impl.test.EnsureCleanDbUtils;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.flowable.eventregistry.test.ChannelDeploymentAnnotation;
import org.flowable.eventregistry.test.EventConfigurationResource;
import org.flowable.eventregistry.test.EventDeploymentAnnotation;
import org.flowable.eventregistry.test.EventDeploymentId;
import org.flowable.eventregistry.test.EventTestHelper;
import org.flowable.eventregistry.test.FlowableEventTestHelper;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowableEventExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    public static final String DEFAULT_CONFIGURATION_RESOURCE = "flowable.eventregistry.cfg.xml";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{FlowableEventExtension.class});
    private static final Set<Class<?>> SUPPORTED_PARAMETERS = new HashSet<Class>(Arrays.asList(EventRegistryEngineConfiguration.class, EventRegistryEngine.class, EventRepositoryService.class, EventRegistry.class));
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void beforeEach(ExtensionContext context) {
        Optional optionalEventDeploymentAnnotation = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), EventDeploymentAnnotation.class);
        Optional optionalChannelDeploymentAnnotation = AnnotationSupport.findAnnotation((Optional)context.getTestMethod(), ChannelDeploymentAnnotation.class);
        if (optionalEventDeploymentAnnotation.isPresent() || optionalChannelDeploymentAnnotation.isPresent()) {
            EventDeploymentAnnotation eventDeploymentAnnotation = null;
            if (optionalEventDeploymentAnnotation.isPresent()) {
                eventDeploymentAnnotation = (EventDeploymentAnnotation)optionalEventDeploymentAnnotation.get();
            }
            ChannelDeploymentAnnotation channelDeploymentAnnotation = null;
            if (optionalChannelDeploymentAnnotation.isPresent()) {
                channelDeploymentAnnotation = (ChannelDeploymentAnnotation)optionalChannelDeploymentAnnotation.get();
            }
            FlowableEventTestHelper testHelper = this.getTestHelper(context);
            String deploymentIdFromDeploymentAnnotation = EventTestHelper.annotationDeploymentSetUp(testHelper.getEventRepositoryService(), context.getRequiredTestClass(), context.getRequiredTestMethod(), eventDeploymentAnnotation, channelDeploymentAnnotation);
            testHelper.setDeploymentIdFromDeploymentAnnotation(deploymentIdFromDeploymentAnnotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) {
        FlowableEventTestHelper flowableTestHelper = this.getTestHelper(context);
        EventRegistryEngine eventRegistryEngine = flowableTestHelper.getEventRegistryEngine();
        String deploymentIdFromDeploymentAnnotation = flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        if (deploymentIdFromDeploymentAnnotation != null) {
            EventTestHelper.annotationDeploymentTearDown(flowableTestHelper.getEventRepositoryService(), deploymentIdFromDeploymentAnnotation, context.getRequiredTestClass(), context.getRequiredTestMethod().getName());
            flowableTestHelper.setDeploymentIdFromDeploymentAnnotation(null);
        }
        try {
            if (context.getTestInstanceLifecycle().orElse(TestInstance.Lifecycle.PER_METHOD) == TestInstance.Lifecycle.PER_METHOD) {
                this.cleanTestAndAssertAndEnsureCleanDb(context, eventRegistryEngine);
            }
        }
        finally {
            eventRegistryEngine.getEventRegistryEngineConfiguration().getClock().reset();
        }
    }

    protected void cleanTestAndAssertAndEnsureCleanDb(ExtensionContext context, EventRegistryEngine eventRegistryEngine) {
        AnnotationSupport.findAnnotation((AnnotatedElement)context.getRequiredTestClass(), EnsureCleanDb.class).ifPresent(ensureCleanDb -> this.assertAndEnsureCleanDb(eventRegistryEngine, context, (EnsureCleanDb)ensureCleanDb));
    }

    protected void assertAndEnsureCleanDb(EventRegistryEngine eventRegistryEngine, ExtensionContext context, EnsureCleanDb ensureCleanDb) {
        EnsureCleanDbUtils.assertAndEnsureCleanDb((String)context.getDisplayName(), (Logger)this.logger, (AbstractEngineConfiguration)eventRegistryEngine.getEventRegistryEngineConfiguration(), (EnsureCleanDb)ensureCleanDb, (!context.getExecutionException().isPresent() ? 1 : 0) != 0, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                SchemaManager schemaManager = CommandContextUtil.getEventRegistryConfiguration(commandContext).getSchemaManager();
                schemaManager.schemaDrop();
                schemaManager.schemaCreate();
                return null;
            }
        });
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext context) {
        Class<?> parameterType = parameterContext.getParameter().getType();
        return SUPPORTED_PARAMETERS.contains(parameterType) || FlowableEventTestHelper.class.equals(parameterType) || parameterContext.isAnnotated(EventDeploymentId.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        EventRegistryEngine eventRegistryEngine;
        FlowableEventTestHelper flowableTestHelper = this.getTestHelper(context);
        if (parameterContext.isAnnotated(EventDeploymentId.class)) {
            return flowableTestHelper.getDeploymentIdFromDeploymentAnnotation();
        }
        Class<?> parameterType = parameterContext.getParameter().getType();
        if (parameterType.isInstance(eventRegistryEngine = flowableTestHelper.getEventRegistryEngine())) {
            return eventRegistryEngine;
        }
        if (FlowableEventTestHelper.class.equals(parameterType)) {
            return flowableTestHelper;
        }
        try {
            return EventRegistryEngine.class.getDeclaredMethod("get" + parameterType.getSimpleName(), new Class[0]).invoke((Object)eventRegistryEngine, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ParameterResolutionException("Could not find service " + parameterType, (Throwable)ex);
        }
    }

    protected String getConfigurationResource(ExtensionContext context) {
        return AnnotationSupport.findAnnotation((Optional)context.getTestClass(), EventConfigurationResource.class).map(EventConfigurationResource::value).orElse(DEFAULT_CONFIGURATION_RESOURCE);
    }

    protected FlowableEventTestHelper getTestHelper(ExtensionContext context) {
        return (FlowableEventTestHelper)this.getStore(context).getOrComputeIfAbsent((Object)context.getRequiredTestClass(), key -> new FlowableEventTestHelper(this.createEventRegistryEngine(context)), FlowableEventTestHelper.class);
    }

    protected EventRegistryEngine createEventRegistryEngine(ExtensionContext context) {
        return EventTestHelper.getEventRegistryEngine(this.getConfigurationResource(context));
    }

    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

