/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.flowable.eventregistry.api.ChannelDefinition;
import org.flowable.eventregistry.api.InboundChannelModelCacheManager;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;

public class DefaultInboundChannelModelCacheManager
implements InboundChannelModelCacheManager {
    protected final EventRegistryEngineConfiguration engineConfiguration;
    protected final Map<CacheKey, CacheValue> cache = new HashMap<CacheKey, CacheValue>();

    public DefaultInboundChannelModelCacheManager(EventRegistryEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    public InboundChannelModelCacheManager.ChannelRegistration registerChannelModel(InboundChannelModel channelModel, ChannelDefinition channelDefinition) {
        String json = this.engineConfiguration.getChannelJsonConverter().convertToJson((ChannelModel)channelModel);
        CacheKey key = new CacheKey(channelDefinition);
        CacheValue cacheValue = this.cache.get(key);
        if (cacheValue == null) {
            this.cache.put(key, new CacheValue(json, channelDefinition));
            return new ChannelRegistrationImpl(true, null, key);
        }
        if (cacheValue.version <= channelDefinition.getVersion()) {
            this.cache.put(key, new CacheValue(json, channelDefinition));
            return new ChannelRegistrationImpl(!cacheValue.json.equals(json), new CacheRegisteredChannel(cacheValue), key);
        }
        return new ChannelRegistrationImpl(false, new CacheRegisteredChannel(cacheValue), key);
    }

    public void unregisterChannelModel(InboundChannelModel channelModel, ChannelDefinition channelDefinition) {
        this.cache.remove(new CacheKey(channelDefinition));
    }

    public void cleanChannelModels() {
        this.cache.clear();
    }

    public InboundChannelModelCacheManager.RegisteredChannel findRegisteredChannel(ChannelDefinition channelDefinition) {
        CacheValue cacheValue = this.cache.get(new CacheKey(channelDefinition));
        return cacheValue != null ? new CacheRegisteredChannel(cacheValue) : null;
    }

    public Collection<InboundChannelModelCacheManager.RegisteredChannel> getRegisteredChannels() {
        if (this.cache.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<InboundChannelModelCacheManager.RegisteredChannel> registeredChannels = new ArrayList<InboundChannelModelCacheManager.RegisteredChannel>(this.cache.size());
        for (Map.Entry<CacheKey, CacheValue> entry : this.cache.entrySet()) {
            registeredChannels.add(new CacheRegisteredChannel(entry.getValue()));
        }
        return registeredChannels;
    }

    protected class ChannelRegistrationImpl
    implements InboundChannelModelCacheManager.ChannelRegistration {
        protected final boolean registered;
        protected final CacheRegisteredChannel previousChannel;
        protected final CacheKey cacheKey;

        public ChannelRegistrationImpl(boolean registered, CacheRegisteredChannel previousChannel, CacheKey cacheKey) {
            this.registered = registered;
            this.previousChannel = previousChannel;
            this.cacheKey = cacheKey;
        }

        public boolean registered() {
            return this.registered;
        }

        public InboundChannelModelCacheManager.RegisteredChannel previousChannel() {
            return this.previousChannel;
        }

        public void rollback() {
            CacheValue cacheValue;
            CacheValue cacheValue2 = cacheValue = this.previousChannel != null ? this.previousChannel.value : null;
            if (cacheValue == null) {
                DefaultInboundChannelModelCacheManager.this.cache.remove(this.cacheKey);
            } else {
                DefaultInboundChannelModelCacheManager.this.cache.put(this.cacheKey, cacheValue);
            }
        }
    }

    protected static class CacheRegisteredChannel
    implements InboundChannelModelCacheManager.RegisteredChannel {
        protected final CacheValue value;

        protected CacheRegisteredChannel(CacheValue value) {
            this.value = value;
        }

        public int getChannelDefinitionVersion() {
            return this.value.version;
        }

        public String getChannelDefinitionId() {
            return this.value.definitionId;
        }
    }

    protected static class CacheValue {
        protected final String json;
        protected final int version;
        protected final String definitionId;

        public CacheValue(String json, ChannelDefinition definition) {
            this.json = json;
            this.version = definition.getVersion();
            this.definitionId = definition.getId();
        }
    }

    protected static class CacheKey {
        protected final String modelKey;
        protected final String tenantId;

        protected CacheKey(ChannelDefinition definition) {
            this.modelKey = definition.getKey();
            this.tenantId = definition.getTenantId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.modelKey, cacheKey.modelKey) && Objects.equals(this.tenantId, cacheKey.tenantId);
        }

        public int hashCode() {
            return Objects.hash(this.modelKey, this.tenantId);
        }
    }
}

