/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.HasExpressionManagerEngineConfiguration;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.OutboundEventChannelAdapter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionOutboundChannelModel;

public class DelegateExpressionOutboundChannelModelProcessor
implements ChannelModelProcessor {
    protected HasExpressionManagerEngineConfiguration engineConfiguration;

    public DelegateExpressionOutboundChannelModelProcessor(HasExpressionManagerEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof DelegateExpressionOutboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof DelegateExpressionOutboundChannelModel) {
            this.registerChannelModel((DelegateExpressionOutboundChannelModel)channelModel);
        }
    }

    protected void registerChannelModel(DelegateExpressionOutboundChannelModel channelModel) {
        String delegateExpression = channelModel.getAdapterDelegateExpression();
        if (StringUtils.isNotEmpty((CharSequence)delegateExpression)) {
            Object channelAdapter = this.engineConfiguration.getExpressionManager().createExpression(delegateExpression).getValue((VariableContainer)new VariableContainerWrapper(Collections.emptyMap()));
            if (!(channelAdapter instanceof OutboundEventChannelAdapter)) {
                throw new FlowableException("DelegateExpression outbound channel model with key " + channelModel.getKey() + " resolved channel adapter delegate expression to " + channelAdapter + " which is not of type " + OutboundEventChannelAdapter.class);
            }
            channelModel.setOutboundEventChannelAdapter(channelAdapter);
        }
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
    }

    public HasExpressionManagerEngineConfiguration getEngineConfiguration() {
        return this.engineConfiguration;
    }

    public void setEngineConfiguration(HasExpressionManagerEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }
}

