/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.pipeline;

import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.HasExpressionManagerEngineConfiguration;
import org.flowable.common.engine.impl.el.VariableContainerWrapper;
import org.flowable.eventregistry.api.ChannelModelProcessor;
import org.flowable.eventregistry.api.EventRegistry;
import org.flowable.eventregistry.api.EventRepositoryService;
import org.flowable.eventregistry.api.InboundEventChannelAdapter;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.DelegateExpressionInboundChannelModel;
import org.flowable.eventregistry.model.InboundChannelModel;

public class DelegateExpressionInboundChannelModelProcessor
implements ChannelModelProcessor {
    protected HasExpressionManagerEngineConfiguration engineConfiguration;

    public DelegateExpressionInboundChannelModelProcessor(HasExpressionManagerEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }

    public boolean canProcess(ChannelModel channelModel) {
        return channelModel instanceof DelegateExpressionInboundChannelModel;
    }

    public void registerChannelModel(ChannelModel channelModel, String tenantId, EventRegistry eventRegistry, EventRepositoryService eventRepositoryService, boolean fallbackToDefaultTenant) {
        if (channelModel instanceof DelegateExpressionInboundChannelModel) {
            this.registerChannelModel((DelegateExpressionInboundChannelModel)channelModel, eventRegistry);
        }
    }

    protected void registerChannelModel(DelegateExpressionInboundChannelModel channelModel, EventRegistry eventRegistry) {
        String delegateExpression = channelModel.getAdapterDelegateExpression();
        if (StringUtils.isNotEmpty((CharSequence)delegateExpression)) {
            Object channelAdapter = this.engineConfiguration.getExpressionManager().createExpression(delegateExpression).getValue((VariableContainer)new VariableContainerWrapper(Collections.emptyMap()));
            if (!(channelAdapter instanceof InboundEventChannelAdapter)) {
                throw new FlowableException("DelegateExpression inbound channel model with key " + channelModel.getKey() + " resolved channel adapter delegate expression to " + channelAdapter + " which is not of type " + InboundEventChannelAdapter.class);
            }
            channelModel.setInboundEventChannelAdapter(channelAdapter);
            ((InboundEventChannelAdapter)channelAdapter).setEventRegistry(eventRegistry);
            ((InboundEventChannelAdapter)channelAdapter).setInboundChannelModel((InboundChannelModel)channelModel);
        }
    }

    public void unregisterChannelModel(ChannelModel channelModel, String tenantId, EventRepositoryService eventRepositoryService) {
    }

    public HasExpressionManagerEngineConfiguration getEngineConfiguration() {
        return this.engineConfiguration;
    }

    public void setEngineConfiguration(HasExpressionManagerEngineConfiguration engineConfiguration) {
        this.engineConfiguration = engineConfiguration;
    }
}

