/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.deployer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.deployer.CachingAndArtifactsManager;
import org.flowable.eventregistry.impl.deployer.ChannelDefinitionDeploymentHelper;
import org.flowable.eventregistry.impl.deployer.EventDefinitionDeploymentHelper;
import org.flowable.eventregistry.impl.deployer.ParsedDeployment;
import org.flowable.eventregistry.impl.deployer.ParsedDeploymentBuilderFactory;
import org.flowable.eventregistry.impl.persistence.deploy.Deployer;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDefinitionEntityManager;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionDeployer
implements Deployer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventDefinitionDeployer.class);
    protected IdGenerator idGenerator;
    protected ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory;
    protected EventDefinitionDeploymentHelper eventDeploymentHelper;
    protected ChannelDefinitionDeploymentHelper channelDeploymentHelper;
    protected CachingAndArtifactsManager cachingAndArtifactsManager;
    protected boolean usePrefixId;

    @Override
    public void deploy(EventDeploymentEntity deployment) {
        LOGGER.debug("Processing deployment {}", (Object)deployment.getName());
        ParsedDeployment parsedDeployment = this.parsedDeploymentBuilderFactory.getBuilderForDeployment(deployment).build();
        this.eventDeploymentHelper.verifyEventDefinitionsDoNotShareKeys(parsedDeployment.getAllEventDefinitions());
        this.channelDeploymentHelper.verifyChannelDefinitionsDoNotShareKeys(parsedDeployment.getAllChannelDefinitions());
        this.eventDeploymentHelper.copyDeploymentValuesToEventDefinitions(parsedDeployment.getDeployment(), parsedDeployment.getAllEventDefinitions());
        this.eventDeploymentHelper.setResourceNamesOnEventDefinitions(parsedDeployment);
        this.channelDeploymentHelper.copyDeploymentValuesToEventDefinitions(parsedDeployment.getDeployment(), parsedDeployment.getAllChannelDefinitions());
        this.channelDeploymentHelper.setResourceNamesOnEventDefinitions(parsedDeployment);
        if (deployment.isNew()) {
            Map<EventDefinitionEntity, EventDefinitionEntity> mapOfNewEventDefinitionToPreviousVersion = this.getPreviousVersionsOfEventDefinitions(parsedDeployment);
            this.setEventDefinitionVersionsAndIds(parsedDeployment, mapOfNewEventDefinitionToPreviousVersion);
            this.persistEventDefinitions(parsedDeployment);
            Map<ChannelDefinitionEntity, ChannelDefinitionEntity> mapOfNewChannelDefinitionToPreviousVersion = this.getPreviousVersionsOfChannelDefinitions(parsedDeployment);
            this.setChannelDefinitionVersionsAndIds(parsedDeployment, mapOfNewChannelDefinitionToPreviousVersion);
            this.persistChannelDefinitions(parsedDeployment);
            for (ChannelDefinitionEntity previousChannelDefinition : mapOfNewChannelDefinitionToPreviousVersion.values()) {
                this.cachingAndArtifactsManager.removeChannelDefinitionFromCache(previousChannelDefinition.getId());
            }
        } else {
            this.makeEventDefinitionsConsistentWithPersistedVersions(parsedDeployment);
            this.makeChannelDefinitionsConsistentWithPersistedVersions(parsedDeployment);
        }
        this.cachingAndArtifactsManager.updateCachingAndArtifacts(parsedDeployment);
    }

    protected Map<EventDefinitionEntity, EventDefinitionEntity> getPreviousVersionsOfEventDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<EventDefinitionEntity, EventDefinitionEntity> result = new LinkedHashMap<EventDefinitionEntity, EventDefinitionEntity>();
        for (EventDefinitionEntity newDefinition : parsedDeployment.getAllEventDefinitions()) {
            EventDefinitionEntity existingEventDefinition = this.eventDeploymentHelper.getMostRecentVersionOfEventDefinition(newDefinition);
            if (existingEventDefinition == null) continue;
            result.put(newDefinition, existingEventDefinition);
        }
        return result;
    }

    protected Map<ChannelDefinitionEntity, ChannelDefinitionEntity> getPreviousVersionsOfChannelDefinitions(ParsedDeployment parsedDeployment) {
        LinkedHashMap<ChannelDefinitionEntity, ChannelDefinitionEntity> result = new LinkedHashMap<ChannelDefinitionEntity, ChannelDefinitionEntity>();
        for (ChannelDefinitionEntity newDefinition : parsedDeployment.getAllChannelDefinitions()) {
            ChannelDefinitionEntity existingChannelDefinition = this.channelDeploymentHelper.getMostRecentVersionOfChannelDefinition(newDefinition);
            if (existingChannelDefinition == null) continue;
            result.put(newDefinition, existingChannelDefinition);
        }
        return result;
    }

    protected void setEventDefinitionVersionsAndIds(ParsedDeployment parsedDeployment, Map<EventDefinitionEntity, EventDefinitionEntity> mapOfNewEventDefinitionToPreviousVersion) {
        for (EventDefinitionEntity eventDefinition : parsedDeployment.getAllEventDefinitions()) {
            int version = 1;
            EventDefinitionEntity latest = mapOfNewEventDefinitionToPreviousVersion.get(eventDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            eventDefinition.setVersion(version);
            if (this.usePrefixId) {
                eventDefinition.setId(eventDefinition.getIdPrefix() + this.idGenerator.getNextId());
                continue;
            }
            eventDefinition.setId(this.idGenerator.getNextId());
        }
    }

    protected void setChannelDefinitionVersionsAndIds(ParsedDeployment parsedDeployment, Map<ChannelDefinitionEntity, ChannelDefinitionEntity> mapOfNewChannelDefinitionToPreviousVersion) {
        for (ChannelDefinitionEntity channelDefinition : parsedDeployment.getAllChannelDefinitions()) {
            int version = 1;
            ChannelDefinitionEntity latest = mapOfNewChannelDefinitionToPreviousVersion.get(channelDefinition);
            if (latest != null) {
                version = latest.getVersion() + 1;
            }
            channelDefinition.setVersion(version);
            if (this.usePrefixId) {
                channelDefinition.setId(channelDefinition.getIdPrefix() + this.idGenerator.getNextId());
                continue;
            }
            channelDefinition.setId(this.idGenerator.getNextId());
        }
    }

    protected void persistEventDefinitions(ParsedDeployment parsedDeployment) {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        EventDefinitionEntityManager eventDefinitionEntityManager = eventRegistryEngineConfiguration.getEventDefinitionEntityManager();
        for (EventDefinitionEntity eventDefinition : parsedDeployment.getAllEventDefinitions()) {
            eventDefinitionEntityManager.insert(eventDefinition);
        }
    }

    protected void persistChannelDefinitions(ParsedDeployment parsedDeployment) {
        EventRegistryEngineConfiguration eventRegistryEngineConfiguration = CommandContextUtil.getEventRegistryConfiguration();
        ChannelDefinitionEntityManager channelDefinitionEntityManager = eventRegistryEngineConfiguration.getChannelDefinitionEntityManager();
        for (ChannelDefinitionEntity channelDefinition : parsedDeployment.getAllChannelDefinitions()) {
            channelDefinitionEntityManager.insert(channelDefinition);
        }
    }

    protected void makeEventDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (EventDefinitionEntity eventDefinition : parsedDeployment.getAllEventDefinitions()) {
            EventDefinitionEntity persistedEventDefinition = this.eventDeploymentHelper.getPersistedInstanceOfEventDefinition(eventDefinition);
            if (persistedEventDefinition == null) continue;
            eventDefinition.setId(persistedEventDefinition.getId());
            eventDefinition.setVersion(persistedEventDefinition.getVersion());
        }
    }

    protected void makeChannelDefinitionsConsistentWithPersistedVersions(ParsedDeployment parsedDeployment) {
        for (ChannelDefinitionEntity channelDefinition : parsedDeployment.getAllChannelDefinitions()) {
            ChannelDefinitionEntity persistedChannelDefinition = this.channelDeploymentHelper.getPersistedInstanceOfChannelDefinition(channelDefinition);
            if (persistedChannelDefinition == null) continue;
            channelDefinition.setId(persistedChannelDefinition.getId());
            channelDefinition.setVersion(persistedChannelDefinition.getVersion());
        }
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public void setIdGenerator(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public ParsedDeploymentBuilderFactory getExParsedDeploymentBuilderFactory() {
        return this.parsedDeploymentBuilderFactory;
    }

    public void setParsedDeploymentBuilderFactory(ParsedDeploymentBuilderFactory parsedDeploymentBuilderFactory) {
        this.parsedDeploymentBuilderFactory = parsedDeploymentBuilderFactory;
    }

    public EventDefinitionDeploymentHelper getEventDeploymentHelper() {
        return this.eventDeploymentHelper;
    }

    public void setEventDeploymentHelper(EventDefinitionDeploymentHelper eventDeploymentHelper) {
        this.eventDeploymentHelper = eventDeploymentHelper;
    }

    public ChannelDefinitionDeploymentHelper getChannelDeploymentHelper() {
        return this.channelDeploymentHelper;
    }

    public void setChannelDeploymentHelper(ChannelDefinitionDeploymentHelper channelDeploymentHelper) {
        this.channelDeploymentHelper = channelDeploymentHelper;
    }

    public CachingAndArtifactsManager getCachingAndArtifcatsManager() {
        return this.cachingAndArtifactsManager;
    }

    public void setCachingAndArtifactsManager(CachingAndArtifactsManager manager) {
        this.cachingAndArtifactsManager = manager;
    }

    public boolean isUsePrefixId() {
        return this.usePrefixId;
    }

    public void setUsePrefixId(boolean usePrefixId) {
        this.usePrefixId = usePrefixId;
    }
}

