/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.jms;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TextMessage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.eventregistry.api.InboundEvent;

public class JmsMessageInboundEvent
implements InboundEvent {
    protected final Message message;
    protected Map<String, Object> headers;

    public JmsMessageInboundEvent(Message message) {
        this.message = message;
    }

    public Message getRawEvent() {
        return this.message;
    }

    public String getBody() {
        return this.convertEventToString();
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = this.retrieveHeaders();
        }
        return this.headers;
    }

    protected Map<String, Object> retrieveHeaders() {
        try {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            Enumeration headerNames = this.message.getPropertyNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                headers.put(headerName, this.message.getObjectProperty(headerName));
            }
            return headers;
        }
        catch (JMSException e) {
            throw new FlowableException("Could not get header information", (Throwable)e);
        }
    }

    protected String convertEventToString() {
        if (this.message instanceof TextMessage) {
            try {
                return ((TextMessage)this.message).getText();
            }
            catch (JMSException e) {
                throw new FlowableException("Could not get body information");
            }
        }
        return this.message.toString();
    }
}

