/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring.autodeployment;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.flowable.eventregistry.api.EventDeploymentBuilder;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.springframework.core.io.Resource;

public abstract class AbstractEventAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<EventRegistryEngine> {
    public AbstractEventAutoDeploymentStrategy() {
    }

    public AbstractEventAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(EventRegistryEngine engine, String deploymentNameHint) {
        return engine.getEventRegistryEngineConfiguration().getLockManager(this.determineLockName(deploymentNameHint));
    }

    protected void addResource(Resource resource, EventDeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, EventDeploymentBuilder deploymentBuilder) {
        try (InputStream inputStream = resource.getInputStream();){
            deploymentBuilder.addInputStream(resourceName, inputStream);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to read resource " + resource, ex);
        }
    }
}

