/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.entitylink.service.impl.persistence.entity;

import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.service.EntityLinkServiceConfiguration;
import org.flowable.entitylink.service.event.impl.FlowableEntityLinkEventBuilder;
import org.flowable.entitylink.service.impl.persistence.entity.AbstractEntityManager;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntityManager;
import org.flowable.entitylink.service.impl.persistence.entity.data.EntityLinkDataManager;

public class EntityLinkEntityManagerImpl
extends AbstractEntityManager<EntityLinkEntity>
implements EntityLinkEntityManager {
    protected EntityLinkDataManager entityLinkDataManager;

    public EntityLinkEntityManagerImpl(EntityLinkServiceConfiguration entityLinkServiceConfiguration, EntityLinkDataManager entityLinkDataManager) {
        super(entityLinkServiceConfiguration);
        this.entityLinkDataManager = entityLinkDataManager;
    }

    @Override
    protected DataManager<EntityLinkEntity> getDataManager() {
        return this.entityLinkDataManager;
    }

    @Override
    public EntityLinkEntity create() {
        EntityLinkEntity entityLinkEntity = (EntityLinkEntity)super.create();
        entityLinkEntity.setCreateTime(this.entityLinkServiceConfiguration.getClock().getCurrentTime());
        return entityLinkEntity;
    }

    @Override
    public List<EntityLink> findEntityLinksByScopeIdAndType(String scopeId, String scopeType, String linkType) {
        return this.entityLinkDataManager.findEntityLinksByScopeIdAndType(scopeId, scopeType, linkType);
    }

    @Override
    public List<EntityLink> findEntityLinksByReferenceScopeIdAndType(String referenceScopeId, String referenceScopeType, String linkType) {
        return this.entityLinkDataManager.findEntityLinksByReferenceScopeIdAndType(referenceScopeId, referenceScopeType, linkType);
    }

    @Override
    public List<EntityLink> findEntityLinksByScopeDefinitionIdAndType(String scopeDefinitionId, String scopeType, String linkType) {
        return this.entityLinkDataManager.findEntityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType, linkType);
    }

    @Override
    public List<EntityLink> deleteScopeEntityLink(String scopeId, String scopeType, String linkType) {
        List<EntityLink> entityLinks = this.findEntityLinksByScopeIdAndType(scopeId, scopeType, linkType);
        for (EntityLink entityLink : entityLinks) {
            this.deleteEntityLink((EntityLinkEntity)entityLink);
        }
        return entityLinks;
    }

    @Override
    public List<EntityLink> deleteScopeDefinitionEntityLink(String scopeDefinitionId, String scopeType, String linkType) {
        List<EntityLink> entityLinks = this.findEntityLinksByScopeDefinitionIdAndType(scopeDefinitionId, scopeType, linkType);
        for (EntityLink entityLink : entityLinks) {
            this.deleteEntityLink((EntityLinkEntity)entityLink);
        }
        return entityLinks;
    }

    public void deleteEntityLink(EntityLinkEntity identityLink) {
        this.delete(identityLink, false);
        FlowableEventDispatcher eventDispatcher = this.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEntityLinkEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, identityLink));
        }
    }

    @Override
    public void deleteEntityLinksByScopeIdAndScopeType(String scopeId, String scopeType) {
        this.entityLinkDataManager.deleteEntityLinksByScopeIdAndScopeType(scopeId, scopeType);
    }

    @Override
    public void deleteEntityLinksByScopeDefinitionIdAndScopeType(String scopeDefinitionId, String scopeType) {
        this.entityLinkDataManager.deleteEntityLinksByScopeDefinitionIdAndScopeType(scopeDefinitionId, scopeType);
    }

    public EntityLinkDataManager getEntityLinkDataManager() {
        return this.entityLinkDataManager;
    }

    public void setEntityLinkDataManager(EntityLinkDataManager entityLinkDataManager) {
        this.entityLinkDataManager = entityLinkDataManager;
    }
}

