/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.variable;

import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.variable.BpmnAggregation;
import org.flowable.variable.api.types.ValueFields;
import org.flowable.variable.api.types.VariableType;

public class BpmnAggregatedVariableType
implements VariableType {
    public static final String TYPE_NAME = "bpmnAggregation";
    protected final ProcessEngineConfigurationImpl processEngineConfiguration;

    public BpmnAggregatedVariableType(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public boolean isCachable() {
        return true;
    }

    public boolean isAbleToStore(Object value) {
        return value instanceof BpmnAggregation;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setValue(Object value, ValueFields valueFields) {
        if (value instanceof BpmnAggregation) {
            valueFields.setTextValue(((BpmnAggregation)value).getExecutionId());
        } else {
            valueFields.setTextValue(null);
        }
    }

    public Object getValue(ValueFields valueFields) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            return BpmnAggregation.aggregateOverview(valueFields.getTextValue(), valueFields.getName(), commandContext);
        }
        return this.processEngineConfiguration.getCommandExecutor().execute(context -> BpmnAggregation.aggregateOverview(valueFields.getTextValue(), valueFields.getName(), context));
    }
}

