/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.parse.BpmnParseHandler;

public abstract class AbstractBpmnParseHandler<T extends BaseElement>
implements BpmnParseHandler {
    public static final String PROPERTYNAME_EVENT_SUBSCRIPTION_DECLARATION = "eventDefinitions";
    public static final String PROPERTYNAME_ERROR_EVENT_DEFINITIONS = "errorEventDefinitions";
    public static final String PROPERTYNAME_TIMER_DECLARATION = "timerDeclarations";

    public Set<Class<? extends BaseElement>> getHandledTypes() {
        HashSet<Class<? extends BaseElement>> types = new HashSet<Class<? extends BaseElement>>();
        types.add(this.getHandledType());
        return types;
    }

    protected abstract Class<? extends BaseElement> getHandledType();

    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        BaseElement baseElement = element;
        this.executeParse(bpmnParse, baseElement);
    }

    protected abstract void executeParse(BpmnParse var1, T var2);

    protected ExecutionListener createExecutionListener(BpmnParse bpmnParse, FlowableListener listener) {
        ExecutionListener executionListener = null;
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createClassDelegateExecutionListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createExpressionExecutionListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            executionListener = bpmnParse.getListenerFactory().createDelegateExpressionExecutionListener(listener);
        }
        return executionListener;
    }

    protected String getPrecedingEventBasedGateway(BpmnParse bpmnParse, IntermediateCatchEvent event) {
        String eventBasedGatewayId = null;
        for (SequenceFlow sequenceFlow : event.getIncomingFlows()) {
            FlowElement sourceElement = bpmnParse.getBpmnModel().getFlowElement(sequenceFlow.getSourceRef());
            if (!(sourceElement instanceof EventGateway)) continue;
            eventBasedGatewayId = sourceElement.getId();
            break;
        }
        return eventBasedGatewayId;
    }

    protected void processArtifacts(BpmnParse bpmnParse, Collection<Artifact> artifacts) {
        for (Artifact artifact : artifacts) {
            if (!(artifact instanceof Association)) continue;
            this.createAssociation(bpmnParse, (Association)artifact);
        }
    }

    protected void createAssociation(BpmnParse bpmnParse, Association association) {
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.getArtifact(association.getSourceRef()) != null || bpmnModel.getArtifact(association.getTargetRef()) != null) {
            // empty if block
        }
    }
}

