/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.event.EventDefinitionExpressionUtil;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.EventSubscriptionUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.eventsubscription.service.impl.persistence.entity.SignalEventSubscriptionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateThrowSignalEventActivityBehavior.class);
    protected ThrowEvent throwEvent;
    protected SignalEventDefinition signalEventDefinition;
    protected boolean processInstanceScope;

    public IntermediateThrowSignalEventActivityBehavior(ThrowEvent throwEvent, SignalEventDefinition signalEventDefinition, Signal signal) {
        if (signal != null && "processInstance".equals(signal.getScope())) {
            this.processInstanceScope = true;
        }
        this.throwEvent = throwEvent;
        this.signalEventDefinition = signalEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        String eventSubscriptionName = EventDefinitionExpressionUtil.determineSignalName(commandContext, this.signalEventDefinition, ProcessDefinitionUtil.getBpmnModel(execution.getProcessDefinitionId()), execution);
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        List subscriptionEntities = null;
        if (this.processInstanceScope) {
            List entityLinks;
            subscriptionEntities = eventSubscriptionService.findSignalEventSubscriptionsByProcessInstanceAndEventName(execution.getProcessInstanceId(), eventSubscriptionName);
            if (processEngineConfiguration.isEnableEntityLinks() && (entityLinks = processEngineConfiguration.getEntityLinkServiceConfiguration().getEntityLinkService().findEntityLinksByReferenceScopeIdAndType(execution.getProcessInstanceId(), "bpmn", "child")) != null) {
                for (EntityLink entityLink : entityLinks) {
                    if ("bpmn".equals(entityLink.getScopeType())) {
                        subscriptionEntities.addAll(eventSubscriptionService.findSignalEventSubscriptionsByProcessInstanceAndEventName(entityLink.getScopeId(), eventSubscriptionName));
                        continue;
                    }
                    if (!"cmmn".equals(entityLink.getScopeType())) continue;
                    subscriptionEntities.addAll(eventSubscriptionService.findSignalEventSubscriptionsByScopeAndEventName(entityLink.getScopeId(), "cmmn", eventSubscriptionName));
                }
            }
        } else {
            subscriptionEntities = eventSubscriptionService.findSignalEventSubscriptionsByEventName(eventSubscriptionName, execution.getTenantId());
        }
        HashMap<String, Object> payload = new HashMap<String, Object>();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        for (IOParameter outParameter : this.throwEvent.getOutParameters()) {
            Object value = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                Expression expression = expressionManager.createExpression(outParameter.getSourceExpression().trim());
                value = expression.getValue((VariableContainer)execution);
            } else {
                value = execution.getVariable(outParameter.getSource());
            }
            String variableName = null;
            if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                variableName = outParameter.getTarget();
            } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                Expression expression = expressionManager.createExpression(outParameter.getTargetExpression());
                Object variableNameValue = expression.getValue((VariableContainer)execution);
                if (variableNameValue != null) {
                    variableName = variableNameValue.toString();
                } else {
                    LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                }
            }
            payload.put(variableName, value);
        }
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
            processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), eventSubscriptionName, null, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, signalEventSubscriptionEntity.getProcessDefinitionId())) {
                Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
                compatibilityHandler.signalEventReceived(signalEventSubscriptionEntity, null, this.signalEventDefinition.isAsync());
                continue;
            }
            EventSubscriptionUtil.eventReceived((EventSubscriptionEntity)signalEventSubscriptionEntity, payload, this.signalEventDefinition.isAsync());
        }
        CommandContextUtil.getAgenda(commandContext).planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, true);
    }
}

