/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.flowable.batch.api.BatchQuery;
import org.flowable.engine.HistoryCleaningManager;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;

public class DefaultHistoryCleaningManager
implements HistoryCleaningManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultHistoryCleaningManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public HistoricProcessInstanceQuery createHistoricProcessInstanceCleaningQuery() {
        return this.processEngineConfiguration.getHistoryService().createHistoricProcessInstanceQuery().finishedBefore(this.getEndedBefore());
    }

    @Override
    public BatchQuery createBatchCleaningQuery() {
        return this.processEngineConfiguration.getManagementService().createBatchQuery().completeTimeLowerThan(this.getEndedBefore()).batchType("historicProcessDelete");
    }

    protected Date getEndedBefore() {
        Duration endedAfterDuration = this.processEngineConfiguration.getCleanInstancesEndedAfter();
        Instant endedBefore = Instant.now().minus(endedAfterDuration);
        return Date.from(endedBefore);
    }
}

