/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.flowable.common.engine.impl.de.odysseus.el.misc.LocalMessages;
import org.flowable.common.engine.impl.de.odysseus.el.tree.Bindings;
import org.flowable.common.engine.impl.de.odysseus.el.tree.IdentifierNode;
import org.flowable.common.engine.impl.de.odysseus.el.tree.impl.ast.AstNode;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELException;
import org.flowable.common.engine.impl.javax.el.MethodExpression;
import org.flowable.common.engine.impl.javax.el.MethodInfo;
import org.flowable.common.engine.impl.javax.el.MethodNotFoundException;
import org.flowable.common.engine.impl.javax.el.PropertyNotFoundException;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.common.engine.impl.javax.el.ValueReference;

public class AstIdentifier
extends AstNode
implements IdentifierNode {
    private final String name;
    private final int index;
    private final boolean ignoreReturnType;

    public AstIdentifier(String name, int index) {
        this(name, index, false);
    }

    public AstIdentifier(String name, int index, boolean ignoreReturnType) {
        this.name = name;
        this.index = index;
        this.ignoreReturnType = ignoreReturnType;
    }

    @Override
    public Class<?> getType(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getType(context);
        }
        context.setPropertyResolved(false);
        Class<?> result = context.getELResolver().getType(context, null, this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return result;
    }

    @Override
    public boolean isLeftValue() {
        return true;
    }

    @Override
    public boolean isMethodInvocation() {
        return false;
    }

    @Override
    public boolean isLiteralText() {
        return false;
    }

    @Override
    public ValueReference getValueReference(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getValueReference(context);
        }
        return new ValueReference(null, this.name);
    }

    @Override
    public Object eval(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.getValue(context);
        }
        context.setPropertyResolved(false);
        Object result = context.getELResolver().getValue(context, null, this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return result;
    }

    @Override
    public void setValue(Bindings bindings, ELContext context, Object value) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            expression.setValue(context, value);
            return;
        }
        context.setPropertyResolved(false);
        Class<?> type = context.getELResolver().getType(context, null, this.name);
        if (context.isPropertyResolved()) {
            if (type != null && (value != null || type.isPrimitive())) {
                value = bindings.convert(value, type);
            }
            context.setPropertyResolved(false);
        }
        context.getELResolver().setValue(context, null, this.name, value);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
    }

    @Override
    public boolean isReadOnly(Bindings bindings, ELContext context) {
        ValueExpression expression = bindings.getVariable(this.index);
        if (expression != null) {
            return expression.isReadOnly(context);
        }
        context.setPropertyResolved(false);
        boolean result = context.getELResolver().isReadOnly(context, null, this.name);
        if (!context.isPropertyResolved()) {
            throw new PropertyNotFoundException(LocalMessages.get("error.identifier.property.notfound", this.name));
        }
        return result;
    }

    protected MethodExpression getMethodExpression(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        Object value = this.eval(bindings, context);
        if (value == null) {
            throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
        }
        if (value instanceof Method) {
            final Method method = this.findAccessibleMethod((Method)value);
            if (method == null) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
            }
            if (!this.ignoreReturnType && returnType != null && !returnType.isAssignableFrom(method.getReturnType())) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.returntype", method.getReturnType(), this.name, returnType));
            }
            if (!Arrays.equals(method.getParameterTypes(), paramTypes)) {
                throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notfound", this.name));
            }
            return new MethodExpression(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isLiteralText() {
                    return false;
                }

                @Override
                public String getExpressionString() {
                    return null;
                }

                @Override
                public int hashCode() {
                    return 0;
                }

                @Override
                public boolean equals(Object obj) {
                    return obj == this;
                }

                @Override
                public Object invoke(ELContext context, Object[] params) {
                    try {
                        return method.invoke(null, params);
                    }
                    catch (IllegalAccessException e) {
                        throw new ELException(LocalMessages.get("error.identifier.method.access", AstIdentifier.this.name), e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new ELException(LocalMessages.get("error.identifier.method.invocation", AstIdentifier.this.name, e));
                    }
                    catch (InvocationTargetException e) {
                        throw new ELException(LocalMessages.get("error.identifier.method.invocation", AstIdentifier.this.name, e.getCause()));
                    }
                }

                @Override
                public MethodInfo getMethodInfo(ELContext context) {
                    return new MethodInfo(method.getName(), method.getReturnType(), method.getParameterTypes());
                }
            };
        }
        if (value instanceof MethodExpression) {
            return (MethodExpression)value;
        }
        throw new MethodNotFoundException(LocalMessages.get("error.identifier.method.notamethod", this.name, value.getClass()));
    }

    @Override
    public MethodInfo getMethodInfo(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes) {
        return this.getMethodExpression(bindings, context, returnType, paramTypes).getMethodInfo(context);
    }

    @Override
    public Object invoke(Bindings bindings, ELContext context, Class<?> returnType, Class<?>[] paramTypes, Object[] params) {
        return this.getMethodExpression(bindings, context, returnType, paramTypes).invoke(context, params);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void appendStructure(StringBuilder b, Bindings bindings) {
        b.append(bindings != null && bindings.isVariableBound(this.index) ? "<var>" : this.name);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getCardinality() {
        return 0;
    }

    @Override
    public AstNode getChild(int i) {
        return null;
    }
}

