/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.async;

import java.time.Duration;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.flowable.common.engine.api.async.AsyncTaskExecutor;
import org.flowable.common.engine.impl.async.AsyncTaskExecutorConfiguration;
import org.flowable.common.engine.impl.util.ExceptionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAsyncTaskExecutor
implements AsyncTaskExecutor {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final AsyncTaskExecutorConfiguration configuration;
    protected ExecutorService executorService;
    protected boolean executorNeedsShutdown;
    protected BlockingQueue<Runnable> threadPoolQueue;
    protected ThreadFactory threadFactory;
    protected RejectedExecutionHandler rejectedExecutionHandler;

    public DefaultAsyncTaskExecutor() {
        this(new AsyncTaskExecutorConfiguration());
        this.configuration.setThreadPoolNamingPattern("flowable-async-job-executor-thread-%d");
    }

    public DefaultAsyncTaskExecutor(AsyncTaskExecutorConfiguration configuration) {
        this.configuration = configuration;
        if (StringUtils.isEmpty((CharSequence)this.configuration.getThreadPoolNamingPattern())) {
            this.configuration.setThreadPoolNamingPattern("flowable-async-job-executor-thread-%d");
        }
    }

    public void execute(Runnable task) {
        this.executorService.execute(task);
    }

    public CompletableFuture<?> submit(Runnable task) {
        return CompletableFuture.runAsync(task, this.executorService);
    }

    public <T> CompletableFuture<T> submit(Callable<T> task) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception exception) {
                ExceptionUtil.sneakyThrow(exception);
                return null;
            }
        }, this.executorService);
    }

    public void start() {
        if (this.executorService == null) {
            this.executorService = this.initializeExecutor();
            this.executorNeedsShutdown = true;
        }
    }

    public void shutdown() {
        if (this.executorService != null && this.executorNeedsShutdown) {
            this.executorService.shutdown();
            try {
                long secondsToWaitOnShutdown = this.configuration.getAwaitTerminationPeriod().getSeconds();
                if (!this.executorService.awaitTermination(secondsToWaitOnShutdown, TimeUnit.SECONDS)) {
                    this.logger.warn("Timeout during shutdown of async job executor. The current running jobs could not end within {} seconds after shutdown operation.", (Object)secondsToWaitOnShutdown);
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while shutting down the async job executor. ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            this.executorService = null;
        }
    }

    protected ExecutorService initializeExecutor() {
        if (this.threadPoolQueue == null) {
            int queueSize = this.getQueueSize();
            this.logger.info("Creating thread pool queue of size {}", (Object)queueSize);
            this.threadPoolQueue = new ArrayBlockingQueue<Runnable>(queueSize);
        }
        if (this.threadFactory == null) {
            String threadPoolNamingPattern = this.getThreadPoolNamingPattern();
            this.logger.info("Creating thread factory with naming pattern {}", (Object)threadPoolNamingPattern);
            this.threadFactory = new BasicThreadFactory.Builder().namingPattern(threadPoolNamingPattern).build();
        }
        int corePoolSize = this.getCorePoolSize();
        int maxPoolSize = this.getMaxPoolSize();
        long keepAliveTime = this.getKeepAliveTime();
        this.logger.info("Creating executor service with corePoolSize {}, maxPoolSize {} and keepAliveTime {}", new Object[]{corePoolSize, maxPoolSize, keepAliveTime});
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, TimeUnit.MILLISECONDS, this.threadPoolQueue, this.threadFactory);
        threadPoolExecutor.allowCoreThreadTimeOut(this.isAllowCoreThreadTimeout());
        if (this.rejectedExecutionHandler != null) {
            this.logger.info("Using rejectedExecutionHandler {}", (Object)this.rejectedExecutionHandler);
            threadPoolExecutor.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        }
        return threadPoolExecutor;
    }

    public AsyncTaskExecutorConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getCorePoolSize() {
        return this.getConfiguration().getCorePoolSize();
    }

    public void setCorePoolSize(int corePoolSize) {
        this.getConfiguration().setCorePoolSize(corePoolSize);
    }

    public int getMaxPoolSize() {
        return this.getConfiguration().getMaxPoolSize();
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.getConfiguration().setMaxPoolSize(maxPoolSize);
    }

    public long getKeepAliveTime() {
        return this.getConfiguration().getKeepAlive().toMillis();
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.getConfiguration().setKeepAlive(Duration.ofMillis(keepAliveTime));
    }

    public int getQueueSize() {
        return this.getConfiguration().getQueueSize();
    }

    public void setQueueSize(int queueSize) {
        this.getConfiguration().setQueueSize(queueSize);
    }

    public boolean isAllowCoreThreadTimeout() {
        return this.getConfiguration().isAllowCoreThreadTimeout();
    }

    public void setAllowCoreThreadTimeout(boolean allowCoreThreadTimeout) {
        this.getConfiguration().setAllowCoreThreadTimeout(allowCoreThreadTimeout);
    }

    public long getSecondsToWaitOnShutdown() {
        return this.getConfiguration().getAwaitTerminationPeriod().getSeconds();
    }

    public void setSecondsToWaitOnShutdown(long secondsToWaitOnShutdown) {
        this.getConfiguration().setAwaitTerminationPeriod(Duration.ofSeconds(secondsToWaitOnShutdown));
    }

    public BlockingQueue<Runnable> getThreadPoolQueue() {
        return this.threadPoolQueue;
    }

    public void setThreadPoolQueue(BlockingQueue<Runnable> threadPoolQueue) {
        this.threadPoolQueue = threadPoolQueue;
    }

    public String getThreadPoolNamingPattern() {
        return this.getConfiguration().getThreadPoolNamingPattern();
    }

    public void setThreadPoolNamingPattern(String threadPoolNamingPattern) {
        this.getConfiguration().setThreadPoolNamingPattern(threadPoolNamingPattern);
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.rejectedExecutionHandler;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public int getRemainingCapacity() {
        return this.threadPoolQueue.remainingCapacity();
    }
}

