/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.agenda;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import org.flowable.common.engine.api.FlowableException;

public class ExecuteFutureActionOperation<T>
implements Runnable {
    protected final CompletableFuture<T> future;
    protected final BiConsumer<T, Throwable> action;

    public ExecuteFutureActionOperation(CompletableFuture<T> future, BiConsumer<T, Throwable> action) {
        this.future = future;
        this.action = action;
    }

    @Override
    public void run() {
        try {
            T value = this.future.get();
            this.action.accept(value, null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlowableException("Future was interrupted", (Throwable)e);
        }
        catch (CancellationException e) {
            this.action.accept(null, new FlowableException("Future was canceled", (Throwable)e));
        }
        catch (ExecutionException e) {
            this.action.accept(null, e.getCause());
        }
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    public BiConsumer<T, Throwable> getAction() {
        return this.action;
    }
}

