/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el.function;

import java.util.Arrays;
import java.util.Objects;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.function.AbstractFlowableVariableExpressionFunction;

public class VariableEqualsExpressionFunction
extends AbstractFlowableVariableExpressionFunction {
    public VariableEqualsExpressionFunction() {
        super(Arrays.asList("equals", "eq"), "equals");
    }

    public static boolean equals(VariableContainer variableContainer, String variableName, Object comparedValue) {
        Object variableValue = VariableEqualsExpressionFunction.getVariableValue(variableContainer, variableName);
        if (comparedValue != null && variableValue != null && VariableEqualsExpressionFunction.valuesAreNumbers(comparedValue, variableValue)) {
            if (variableValue instanceof Long) {
                return ((Number)variableValue).longValue() == ((Number)comparedValue).longValue();
            }
            if (variableValue instanceof Integer) {
                return ((Number)variableValue).intValue() == ((Number)comparedValue).intValue();
            }
            if (variableValue instanceof Double) {
                return ((Number)variableValue).doubleValue() == ((Number)comparedValue).doubleValue();
            }
            if (variableValue instanceof Float) {
                return ((Number)variableValue).floatValue() == ((Number)comparedValue).floatValue();
            }
            if (variableValue instanceof Short) {
                return ((Number)variableValue).shortValue() == ((Number)comparedValue).shortValue();
            }
        }
        return VariableEqualsExpressionFunction.defaultEquals(comparedValue, variableValue);
    }

    protected static boolean defaultEquals(Object variableValue, Object actualValue) {
        return Objects.equals(actualValue, variableValue);
    }
}

