/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.converter.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.converter.child.AllowedValuesParser;
import org.flowable.dmn.converter.child.BaseChildElementParser;
import org.flowable.dmn.converter.child.InputClauseParser;
import org.flowable.dmn.converter.child.InputEntryParser;
import org.flowable.dmn.converter.child.InputExpressionParser;
import org.flowable.dmn.converter.child.InputValuesParser;
import org.flowable.dmn.converter.child.ItemComponentParser;
import org.flowable.dmn.converter.child.OutputClauseParser;
import org.flowable.dmn.converter.child.OutputEntryParser;
import org.flowable.dmn.converter.child.OutputValuesParser;
import org.flowable.dmn.converter.child.RequiredAuthorityParser;
import org.flowable.dmn.converter.child.RequiredDecisionParser;
import org.flowable.dmn.converter.child.RequiredInputParser;
import org.flowable.dmn.converter.child.TypeRefParser;
import org.flowable.dmn.converter.child.VariableParser;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DmnElement;
import org.flowable.dmn.model.DmnExtensionAttribute;
import org.flowable.dmn.model.DmnExtensionElement;
import org.flowable.dmn.xml.constants.DmnXMLConstants;

public class DmnXMLUtil
implements DmnXMLConstants {
    private static Map<String, BaseChildElementParser> genericChildParserMap = new HashMap<String, BaseChildElementParser>();

    private static void addGenericParser(BaseChildElementParser parser) {
        genericChildParserMap.put(parser.getElementName(), parser);
    }

    public static void parseChildElements(String elementName, DmnElement parentElement, XMLStreamReader xtr, Map<String, BaseChildElementParser> childParsers, Decision decision) throws Exception {
        HashMap<String, BaseChildElementParser> localParserMap = new HashMap<String, BaseChildElementParser>(genericChildParserMap);
        if (childParsers != null) {
            localParserMap.putAll(childParsers);
        }
        boolean inExtensionElements = false;
        boolean readyWithChildElements = false;
        while (!readyWithChildElements && xtr.hasNext()) {
            xtr.next();
            if (xtr.isStartElement()) {
                if ("extensionElements".equals(xtr.getLocalName())) {
                    inExtensionElements = true;
                    continue;
                }
                if (localParserMap.containsKey(xtr.getLocalName())) {
                    BaseChildElementParser childParser = (BaseChildElementParser)localParserMap.get(xtr.getLocalName());
                    if (inExtensionElements && !childParser.accepts(parentElement)) {
                        DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                        parentElement.addExtensionElement(extensionElement);
                        continue;
                    }
                    ((BaseChildElementParser)localParserMap.get(xtr.getLocalName())).parseChildElement(xtr, parentElement, decision);
                    continue;
                }
                if (!inExtensionElements) continue;
                DmnExtensionElement extensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                parentElement.addExtensionElement(extensionElement);
                continue;
            }
            if (!xtr.isEndElement()) continue;
            if ("extensionElements".equals(xtr.getLocalName())) {
                inExtensionElements = false;
                continue;
            }
            if (!elementName.equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithChildElements = true;
        }
    }

    public static void writeDefaultAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value) && !"null".equalsIgnoreCase(value)) {
            xtw.writeAttribute(attributeName, value);
        }
    }

    public static void writeQualifiedAttribute(String attributeName, String value, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            xtw.writeAttribute("flowable", "http://flowable.org/dmn", attributeName, value);
        }
    }

    public static DmnExtensionElement parseExtensionElement(XMLStreamReader xtr) throws Exception {
        DmnExtensionElement extensionElement = new DmnExtensionElement();
        extensionElement.setName(xtr.getLocalName());
        if (StringUtils.isNotEmpty((CharSequence)xtr.getNamespaceURI())) {
            extensionElement.setNamespace(xtr.getNamespaceURI());
        }
        if (StringUtils.isNotEmpty((CharSequence)xtr.getPrefix())) {
            extensionElement.setNamespacePrefix(xtr.getPrefix());
        }
        DmnXMLUtil.parseAttributes((DmnElement)extensionElement, xtr);
        boolean readyWithExtensionElement = false;
        while (!readyWithExtensionElement && xtr.hasNext()) {
            xtr.next();
            if (xtr.isCharacters() || 12 == xtr.getEventType()) {
                if (!StringUtils.isNotEmpty((CharSequence)xtr.getText().trim())) continue;
                extensionElement.setElementText(xtr.getText().trim());
                continue;
            }
            if (xtr.isStartElement()) {
                DmnExtensionElement childExtensionElement = DmnXMLUtil.parseExtensionElement(xtr);
                extensionElement.addChildElement(childExtensionElement);
                continue;
            }
            if (!xtr.isEndElement() || !extensionElement.getName().equalsIgnoreCase(xtr.getLocalName())) continue;
            readyWithExtensionElement = true;
        }
        return extensionElement;
    }

    public static void parseAttributes(DmnElement dmnElement, XMLStreamReader xtr) {
        DmnXMLUtil.parseAttributes(dmnElement, xtr, Collections.emptyList());
    }

    public static void parseAttributes(DmnElement dmnElement, XMLStreamReader xtr, Collection<DmnExtensionAttribute> attributesToIgnore) {
        for (int i = 0; i < xtr.getAttributeCount(); ++i) {
            DmnExtensionAttribute extensionAttribute = new DmnExtensionAttribute();
            extensionAttribute.setName(xtr.getAttributeLocalName(i));
            extensionAttribute.setValue(xtr.getAttributeValue(i));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeNamespace(i))) {
                extensionAttribute.setNamespace(xtr.getAttributeNamespace(i));
            }
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributePrefix(i))) {
                extensionAttribute.setNamespacePrefix(xtr.getAttributePrefix(i));
            }
            if (!DmnXMLUtil.isAttributedIncluded(extensionAttribute, attributesToIgnore)) continue;
            dmnElement.addAttribute(extensionAttribute);
        }
    }

    protected static boolean isAttributedIncluded(DmnExtensionAttribute attribute, Collection<DmnExtensionAttribute> attributesToIgnore) {
        if (attributesToIgnore.isEmpty()) {
            return true;
        }
        for (DmnExtensionAttribute attributeToIgnore : attributesToIgnore) {
            if (!Objects.equals(attributeToIgnore.getName(), attribute.getName()) || !Objects.equals(attributeToIgnore.getNamespace(), attribute.getNamespace())) continue;
            return false;
        }
        return true;
    }

    public static void writeElementDescription(DmnElement dmnElement, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)dmnElement.getDescription()) && !"null".equalsIgnoreCase(dmnElement.getDescription())) {
            xtw.writeStartElement("description");
            xtw.writeCharacters(dmnElement.getDescription());
            xtw.writeEndElement();
        }
    }

    public static void writeExtensionElements(DmnElement dmnElement, XMLStreamWriter xtw) throws Exception {
        DmnXMLUtil.writeExtensionElements(dmnElement, null, xtw);
    }

    public static void writeExtensionElements(DmnElement dmnElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (DmnXMLUtil.writeExtensionElements(dmnElement, false, xtw)) {
            xtw.writeEndElement();
        }
    }

    public static boolean writeExtensionElements(DmnElement dmnElement, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        return DmnXMLUtil.writeExtensionElements(dmnElement, didWriteExtensionStartElement, null, xtw);
    }

    public static boolean writeExtensionElements(DmnElement dmnElement, boolean didWriteExtensionStartElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (!dmnElement.getExtensionElements().isEmpty()) {
            if (!didWriteExtensionStartElement) {
                xtw.writeStartElement("extensionElements");
                didWriteExtensionStartElement = true;
            }
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, String>();
            }
            for (List extensionElements : dmnElement.getExtensionElements().values()) {
                for (DmnExtensionElement extensionElement : extensionElements) {
                    DmnXMLUtil.writeExtensionElement(extensionElement, namespaceMap, xtw);
                }
            }
        }
        return didWriteExtensionStartElement;
    }

    protected static void writeExtensionElement(DmnExtensionElement extensionElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)extensionElement.getName())) {
            HashMap<String, String> localNamespaceMap = new HashMap<String, String>();
            if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespace())) {
                if (StringUtils.isNotEmpty((CharSequence)extensionElement.getNamespacePrefix())) {
                    xtw.writeStartElement(extensionElement.getNamespacePrefix(), extensionElement.getName(), extensionElement.getNamespace());
                    if (!namespaceMap.containsKey(extensionElement.getNamespacePrefix()) || !namespaceMap.get(extensionElement.getNamespacePrefix()).equals(extensionElement.getNamespace())) {
                        xtw.writeNamespace(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        namespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                        localNamespaceMap.put(extensionElement.getNamespacePrefix(), extensionElement.getNamespace());
                    }
                } else {
                    xtw.writeStartElement(extensionElement.getNamespace(), extensionElement.getName());
                }
            } else {
                xtw.writeStartElement(extensionElement.getName());
            }
            DmnXMLUtil.writeAttributes((DmnElement)extensionElement, namespaceMap, xtw);
            if (extensionElement.getElementText() != null) {
                xtw.writeCharacters(extensionElement.getElementText());
            } else {
                for (List childElements : extensionElement.getChildElements().values()) {
                    for (DmnExtensionElement childElement : childElements) {
                        DmnXMLUtil.writeExtensionElement(childElement, namespaceMap, xtw);
                    }
                }
            }
            for (String prefix : localNamespaceMap.keySet()) {
                namespaceMap.remove(prefix);
            }
            xtw.writeEndElement();
        }
    }

    public static void writeAttributes(DmnElement dmnElement, Map<String, String> namespaceMap, XMLStreamWriter xtw) throws Exception {
        if (!dmnElement.getAttributes().isEmpty()) {
            if (namespaceMap == null) {
                namespaceMap = new HashMap<String, String>();
            }
            for (List attributes : dmnElement.getAttributes().values()) {
                for (DmnExtensionAttribute attribute : attributes) {
                    if (!StringUtils.isNotEmpty((CharSequence)attribute.getName()) || attribute.getValue() == null) continue;
                    if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespace())) {
                        if (StringUtils.isNotEmpty((CharSequence)attribute.getNamespacePrefix())) {
                            if (!namespaceMap.containsKey(attribute.getNamespacePrefix()) || !namespaceMap.get(attribute.getNamespacePrefix()).equals(attribute.getNamespace())) {
                                xtw.writeNamespace(attribute.getNamespacePrefix(), attribute.getNamespace());
                                namespaceMap.put(attribute.getNamespacePrefix(), attribute.getNamespace());
                            }
                            xtw.writeAttribute(attribute.getNamespacePrefix(), attribute.getNamespace(), attribute.getName(), attribute.getValue());
                            continue;
                        }
                        xtw.writeAttribute(attribute.getNamespace(), attribute.getName(), attribute.getValue());
                        continue;
                    }
                    xtw.writeAttribute(attribute.getName(), attribute.getValue());
                }
            }
        }
    }

    public static String getUniqueElementId() {
        return DmnXMLUtil.getUniqueElementId(null);
    }

    public static String getUniqueElementId(String prefix) {
        UUID uuid = UUID.randomUUID();
        if (StringUtils.isEmpty((CharSequence)prefix)) {
            return uuid.toString();
        }
        return String.format("%s_%s", prefix, uuid);
    }

    static {
        DmnXMLUtil.addGenericParser(new InputClauseParser());
        DmnXMLUtil.addGenericParser(new OutputClauseParser());
        DmnXMLUtil.addGenericParser(new InputEntryParser());
        DmnXMLUtil.addGenericParser(new OutputEntryParser());
        DmnXMLUtil.addGenericParser(new InputExpressionParser());
        DmnXMLUtil.addGenericParser(new InputValuesParser());
        DmnXMLUtil.addGenericParser(new OutputValuesParser());
        DmnXMLUtil.addGenericParser(new VariableParser());
        DmnXMLUtil.addGenericParser(new RequiredAuthorityParser());
        DmnXMLUtil.addGenericParser(new RequiredDecisionParser());
        DmnXMLUtil.addGenericParser(new RequiredInputParser());
        DmnXMLUtil.addGenericParser(new AllowedValuesParser());
        DmnXMLUtil.addGenericParser(new ItemComponentParser());
        DmnXMLUtil.addGenericParser(new TypeRefParser());
    }
}

