/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletResponse;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.rest.service.api.repository.BaseDecisionResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"Decisions"}, description="Manage Decisions", authorizations={@Authorization(value="basicAuth")})
public class DecisionResourceDataResource
extends BaseDecisionResource {
    @ApiOperation(value="Get a decision resource content", tags={"Decisions"})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates both decision and resource have been found and the resource data has been returned."), @ApiResponse(code=404, message="Indicates the requested decision was not found or there is no resource with the given id present in the decision . The status-description contains additional information.")})
    @GetMapping(value={"/dmn-repository/decisions/{decisionId}/resourcedata"}, produces={"application/json"})
    @ResponseBody
    public byte[] getDecisionResource(@ApiParam(name="decisionId") @PathVariable String decisionId, HttpServletResponse response) {
        DmnDecision decision = this.getDecisionFromRequest(decisionId);
        return this.getDeploymentResourceData(decision.getDeploymentId(), decision.getResourceName(), response);
    }
}

