/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.rest.resolver.ContentTypeResolver;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseDmnDeploymentResourceDataResource {
    @Autowired
    protected ContentTypeResolver contentTypeResolver;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    protected byte[] getDmnDeploymentResourceData(String deploymentId, String resourceName, HttpServletResponse response) {
        List resourceList;
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("No deployment id provided");
        }
        if (resourceName == null) {
            throw new FlowableIllegalArgumentException("No resource name provided");
        }
        DmnDeploymentQuery deploymentQuery = this.dmnRepositoryService.createDeploymentQuery().deploymentId(deploymentId);
        DmnDeployment deployment = (DmnDeployment)deploymentQuery.singleResult();
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("Could not find a DMN deployment with id '" + deploymentId);
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentById(deployment);
        }
        if ((resourceList = this.dmnRepositoryService.getDeploymentResourceNames(deploymentId)).contains(resourceName)) {
            byte[] byArray;
            block13: {
                String contentType = this.contentTypeResolver.resolveContentType(resourceName);
                response.setContentType(contentType);
                InputStream resourceStream = this.dmnRepositoryService.getResourceAsStream(deploymentId, resourceName);
                try {
                    byArray = IOUtils.toByteArray((InputStream)resourceStream);
                    if (resourceStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (resourceStream != null) {
                            try {
                                resourceStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new FlowableException("Error converting resource stream", (Throwable)e);
                    }
                }
                resourceStream.close();
            }
            return byArray;
        }
        throw new FlowableObjectNotFoundException("Could not find a resource with name '" + resourceName + "' in deployment '" + deploymentId);
    }
}

