/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.cmmn.model.HasInParameters;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.cmmn.model.ServiceTask;

public class ScriptServiceTask
extends ServiceTask
implements HasInParameters {
    public static final String SCRIPT_TASK = "script";
    protected boolean autoStoreVariables;
    protected boolean doNotIncludeVariables = false;
    protected List<IOParameter> inParameters;

    public ScriptServiceTask() {
        this.type = SCRIPT_TASK;
    }

    public String getScriptFormat() {
        return this.implementationType;
    }

    public void setScriptFormat(String scriptFormat) {
        this.implementationType = scriptFormat;
    }

    public String getScript() {
        for (FieldExtension fieldExtension : this.fieldExtensions) {
            if (!SCRIPT_TASK.equalsIgnoreCase(fieldExtension.getFieldName())) continue;
            String script = fieldExtension.getStringValue();
            if (StringUtils.isNotEmpty((CharSequence)script)) {
                return script;
            }
            return fieldExtension.getExpression();
        }
        return null;
    }

    public boolean isAutoStoreVariables() {
        return this.autoStoreVariables;
    }

    public void setAutoStoreVariables(boolean autoStoreVariables) {
        this.autoStoreVariables = autoStoreVariables;
    }

    public boolean isDoNotIncludeVariables() {
        return this.doNotIncludeVariables;
    }

    public void setDoNotIncludeVariables(boolean doNotIncludeVariables) {
        this.doNotIncludeVariables = doNotIncludeVariables;
    }

    @Override
    public List<IOParameter> getInParameters() {
        return this.inParameters;
    }

    @Override
    public void addInParameter(IOParameter inParameter) {
        if (this.inParameters == null) {
            this.inParameters = new ArrayList<IOParameter>();
        }
        this.inParameters.add(inParameter);
    }

    @Override
    public void setInParameters(List<IOParameter> inParameters) {
        this.inParameters = inParameters;
    }

    @Override
    public ScriptServiceTask clone() {
        ScriptServiceTask clone = new ScriptServiceTask();
        clone.setValues(this);
        return clone;
    }

    public void setValues(ScriptServiceTask otherElement) {
        super.setValues(otherElement);
        this.setDoNotIncludeVariables(otherElement.isDoNotIncludeVariables());
        this.inParameters = null;
        if (otherElement.getInParameters() != null && !otherElement.getInParameters().isEmpty()) {
            this.inParameters = new ArrayList<IOParameter>();
            for (IOParameter parameter : otherElement.getInParameters()) {
                this.inParameters.add(parameter.clone());
            }
        }
    }
}

