/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.ActivityProcessor;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterContext;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.GraphicInfo;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;
import org.flowable.cmmn.model.Stage;

public class StageJsonConverter
extends BaseCmmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        StageJsonConverter.fillJsonTypes(convertersToCmmnMap);
        StageJsonConverter.fillCmmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseCmmnJsonConverter>> convertersToCmmnMap) {
        convertersToCmmnMap.put("Stage", StageJsonConverter.class);
    }

    public static void fillCmmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseCmmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(Stage.class, StageJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "Stage";
    }

    @Override
    protected void convertElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, ActivityProcessor processor, BaseElement baseElement, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext) {
        PlanItem planItem = (PlanItem)baseElement;
        Stage stage = (Stage)planItem.getPlanItemDefinition();
        if (stage.getDisplayOrder() != null) {
            propertiesNode.put("displayorder", stage.getDisplayOrder());
        }
        if ("true".equalsIgnoreCase(stage.getIncludeInStageOverview())) {
            propertiesNode.put("includeinstageoverview", true);
        }
        GraphicInfo graphicInfo = cmmnModel.getGraphicInfo(planItem.getId());
        ArrayNode subProcessShapesArrayNode = this.objectMapper.createArrayNode();
        processor.processPlanItems(stage, cmmnModel, subProcessShapesArrayNode, converterContext, graphicInfo.getX(), graphicInfo.getY());
        elementNode.set("childShapes", (JsonNode)subProcessShapesArrayNode);
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, (PlanItemDefinition)stage);
    }

    protected CaseElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, ActivityProcessor processor, BaseElement parentElement, Map<String, JsonNode> shapeMap, CmmnModel cmmnModel, CmmnJsonConverterContext converterContext, CmmnJsonConverter.CmmnModelIdHelper cmmnModelIdHelper) {
        Stage stage = new Stage();
        stage.setId(CmmnJsonConverterUtil.getElementId(elementNode));
        stage.setAutoComplete(CmmnJsonConverterUtil.getPropertyValueAsBoolean("autocompleteenabled", elementNode));
        String autoCompleteCondition = CmmnJsonConverterUtil.getPropertyValueAsString("autocompletecondition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)autoCompleteCondition)) {
            stage.setAutoCompleteCondition(autoCompleteCondition);
        }
        stage.setDisplayOrder(CmmnJsonConverterUtil.getPropertyValueAsInteger("displayorder", elementNode));
        String includeInStageOverview = String.valueOf(CmmnJsonConverterUtil.getPropertyValueAsBoolean("includeinstageoverview", elementNode, true));
        stage.setIncludeInStageOverview(includeInStageOverview);
        JsonNode childShapesArray = elementNode.get("childShapes");
        processor.processJsonElements(childShapesArray, modelNode, (BaseElement)stage, shapeMap, converterContext, cmmnModel, cmmnModelIdHelper);
        Stage parentStage = (Stage)parentElement;
        stage.setParent((PlanFragment)parentStage);
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)stage);
        return stage;
    }
}

