/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.editor.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.editor.json.converter.BaseCmmnJsonConverter;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverterUtil;
import org.flowable.cmmn.editor.json.converter.util.ListenerConverterUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemDefinition;

public abstract class AbstractEventListenerJsonConverter
extends BaseCmmnJsonConverter {
    protected void convertCommonElementToJson(ObjectNode elementNode, ObjectNode propertiesNode, BaseElement baseElement) {
        EventListener eventListener;
        PlanItemDefinition planItemDefinition = ((PlanItem)baseElement).getPlanItemDefinition();
        ListenerConverterUtil.convertLifecycleListenersToJson(this.objectMapper, propertiesNode, planItemDefinition);
        if (planItemDefinition instanceof EventListener && StringUtils.isNotEmpty((CharSequence)(eventListener = (EventListener)planItemDefinition).getAvailableConditionExpression())) {
            propertiesNode.put("availablecondition", eventListener.getAvailableConditionExpression());
        }
    }

    protected void convertCommonJsonToElement(JsonNode elementNode, EventListener eventListener) {
        ListenerConverterUtil.convertJsonToLifeCycleListeners(elementNode, (PlanItemDefinition)eventListener);
        String availableCondition = CmmnJsonConverterUtil.getPropertyValueAsString("availablecondition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)availableCondition)) {
            eventListener.setAvailableConditionExpression(availableCondition);
        }
    }
}

