/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.runtime.CaseInstanceStartEventSubscriptionBuilder;
import org.flowable.cmmn.engine.impl.runtime.CmmnRuntimeServiceImpl;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.eventsubscription.api.EventSubscription;

public class CaseInstanceStartEventSubscriptionBuilderImpl
implements CaseInstanceStartEventSubscriptionBuilder {
    protected final CmmnRuntimeServiceImpl cmmnRuntimeService;
    protected String caseDefinitionKey;
    protected String tenantId;
    protected final Map<String, Object> correlationParameterValues = new HashMap<String, Object>();
    protected boolean doNotUpdateToLatestVersionAutomatically;

    public CaseInstanceStartEventSubscriptionBuilderImpl(CmmnRuntimeServiceImpl cmmnRuntimeService) {
        this.cmmnRuntimeService = cmmnRuntimeService;
    }

    public CaseInstanceStartEventSubscriptionBuilder caseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    public CaseInstanceStartEventSubscriptionBuilder doNotUpdateToLatestVersionAutomatically() {
        this.doNotUpdateToLatestVersionAutomatically = true;
        return this;
    }

    public CaseInstanceStartEventSubscriptionBuilder addCorrelationParameterValue(String parameterName, Object parameterValue) {
        this.correlationParameterValues.put(parameterName, parameterValue);
        return this;
    }

    public CaseInstanceStartEventSubscriptionBuilder addCorrelationParameterValues(Map<String, Object> parameters) {
        this.correlationParameterValues.putAll(parameters);
        return this;
    }

    public CaseInstanceStartEventSubscriptionBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public Map<String, Object> getCorrelationParameterValues() {
        return this.correlationParameterValues;
    }

    public boolean isDoNotUpdateToLatestVersionAutomatically() {
        return this.doNotUpdateToLatestVersionAutomatically;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public EventSubscription subscribe() {
        this.checkValidInformation();
        return this.cmmnRuntimeService.registerCaseInstanceStartEventSubscription(this);
    }

    protected void checkValidInformation() {
        if (StringUtils.isEmpty((CharSequence)this.caseDefinitionKey)) {
            throw new FlowableIllegalArgumentException("The case definition must be provided using the key for the subscription to be registered.");
        }
        if (this.correlationParameterValues.isEmpty()) {
            throw new FlowableIllegalArgumentException("At least one correlation parameter value must be provided for a dynamic case start event subscription, otherwise the case would get started on all events, regardless their correlation parameter values.");
        }
    }
}

