/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.migration;

import java.util.Map;
import org.flowable.batch.api.Batch;
import org.flowable.cmmn.api.CmmnMigrationService;
import org.flowable.cmmn.api.migration.ActivatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationBuilder;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationDocument;
import org.flowable.cmmn.api.migration.CaseInstanceMigrationValidationResult;
import org.flowable.cmmn.api.migration.ChangePlanItemIdMapping;
import org.flowable.cmmn.api.migration.ChangePlanItemIdWithDefinitionIdMapping;
import org.flowable.cmmn.api.migration.MoveToAvailablePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.RemoveWaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.TerminatePlanItemDefinitionMapping;
import org.flowable.cmmn.api.migration.WaitingForRepetitionPlanItemDefinitionMapping;
import org.flowable.cmmn.engine.impl.migration.CaseInstanceMigrationDocumentBuilderImpl;
import org.flowable.common.engine.api.FlowableException;

public class CaseInstanceMigrationBuilderImpl
implements CaseInstanceMigrationBuilder {
    protected CmmnMigrationService cmmnMigrationService;
    protected CaseInstanceMigrationDocumentBuilderImpl caseInstanceMigrationDocumentDocumentBuilder = new CaseInstanceMigrationDocumentBuilderImpl();

    public CaseInstanceMigrationBuilderImpl(CmmnMigrationService cmmnMigrationService) {
        this.cmmnMigrationService = cmmnMigrationService;
    }

    public CaseInstanceMigrationBuilder fromCaseInstanceMigrationDocument(CaseInstanceMigrationDocument caseInstanceMigrationDocument) {
        this.caseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseInstanceMigrationDocument.getMigrateToCaseDefinitionId());
        this.caseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseInstanceMigrationDocument.getMigrateToCaseDefinitionKey(), caseInstanceMigrationDocument.getMigrateToCaseDefinitionVersion());
        this.caseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseInstanceMigrationDocument.getMigrateToCaseDefinitionTenantId());
        this.caseInstanceMigrationDocumentDocumentBuilder.addActivatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getActivatePlanItemDefinitionMappings());
        this.caseInstanceMigrationDocumentDocumentBuilder.addTerminatePlanItemDefinitionMappings(caseInstanceMigrationDocument.getTerminatePlanItemDefinitionMappings());
        this.caseInstanceMigrationDocumentDocumentBuilder.addMoveToAvailablePlanItemDefinitionMappings(caseInstanceMigrationDocument.getMoveToAvailablePlanItemDefinitionMappings());
        this.caseInstanceMigrationDocumentDocumentBuilder.addWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getWaitingForRepetitionPlanItemDefinitionMappings());
        this.caseInstanceMigrationDocumentDocumentBuilder.addRemoveWaitingForRepetitionPlanItemDefinitionMappings(caseInstanceMigrationDocument.getRemoveWaitingForRepetitionPlanItemDefinitionMappings());
        this.caseInstanceMigrationDocumentDocumentBuilder.addCaseInstanceVariables(caseInstanceMigrationDocument.getCaseInstanceVariables());
        return this;
    }

    public CaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionId) {
        this.caseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionId);
        return this;
    }

    public CaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionKey, int caseDefinitionVersion) {
        this.caseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
        return this;
    }

    public CaseInstanceMigrationBuilder migrateToCaseDefinition(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        this.caseInstanceMigrationDocumentDocumentBuilder.setCaseDefinitionToMigrateTo(caseDefinitionKey, caseDefinitionVersion);
        this.caseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseDefinitionTenantId);
        return this;
    }

    public CaseInstanceMigrationBuilder withMigrateToCaseDefinitionTenantId(String caseDefinitionTenantId) {
        this.caseInstanceMigrationDocumentDocumentBuilder.setTenantId(caseDefinitionTenantId);
        return this;
    }

    public CaseInstanceMigrationBuilder addActivatePlanItemDefinitionMapping(ActivatePlanItemDefinitionMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addActivatePlanItemDefinitionMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder addTerminatePlanItemDefinitionMapping(TerminatePlanItemDefinitionMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addTerminatePlanItemDefinitionMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder addMoveToAvailablePlanItemDefinitionMapping(MoveToAvailablePlanItemDefinitionMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addMoveToAvailablePlanItemDefinitionMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder addWaitingForRepetitionPlanItemDefinitionMapping(WaitingForRepetitionPlanItemDefinitionMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addWaitingForRepetitionPlanItemDefinitionMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder removeWaitingForRepetitionPlanItemDefinitionMapping(RemoveWaitingForRepetitionPlanItemDefinitionMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addRemoveWaitingForRepetitionPlanItemDefinitionMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder addChangePlanItemIdMapping(ChangePlanItemIdMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addChangePlanItemIdMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder addChangePlanItemIdWithDefinitionIdMapping(ChangePlanItemIdWithDefinitionIdMapping mapping) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addChangePlanItemIdWithDefinitionIdMapping(mapping);
        return this;
    }

    public CaseInstanceMigrationBuilder withPreUpgradeExpression(String preUpgradeExpression) {
        this.caseInstanceMigrationDocumentDocumentBuilder.preUpgradeExpression(preUpgradeExpression);
        return this;
    }

    public CaseInstanceMigrationBuilder withPostUpgradeExpression(String postUpgradeExpression) {
        this.caseInstanceMigrationDocumentDocumentBuilder.postUpgradeExpression(postUpgradeExpression);
        return this;
    }

    public CaseInstanceMigrationBuilder withCaseInstanceVariable(String variableName, Object variableValue) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addCaseInstanceVariable(variableName, variableValue);
        return this;
    }

    public CaseInstanceMigrationBuilder withCaseInstanceVariables(Map<String, Object> variables) {
        this.caseInstanceMigrationDocumentDocumentBuilder.addCaseInstanceVariables(variables);
        return this;
    }

    public CaseInstanceMigrationDocument getCaseInstanceMigrationDocument() {
        return this.caseInstanceMigrationDocumentDocumentBuilder.build();
    }

    public void migrate(String caseInstanceId) {
        this.getCmmnMigrationService().migrateCaseInstance(caseInstanceId, this.getCaseInstanceMigrationDocument());
    }

    public CaseInstanceMigrationValidationResult validateMigration(String caseInstanceId) {
        return this.getCmmnMigrationService().validateMigrationForCaseInstance(caseInstanceId, this.getCaseInstanceMigrationDocument());
    }

    public void migrateCaseInstances(String caseDefinitionId) {
        this.getCmmnMigrationService().migrateCaseInstancesOfCaseDefinition(caseDefinitionId, this.getCaseInstanceMigrationDocument());
    }

    public Batch batchMigrateCaseInstances(String caseDefinitionId) {
        return this.getCmmnMigrationService().batchMigrateCaseInstancesOfCaseDefinition(caseDefinitionId, this.getCaseInstanceMigrationDocument());
    }

    public CaseInstanceMigrationValidationResult validateMigrationOfCaseInstances(String caseDefinitionId) {
        return this.getCmmnMigrationService().validateMigrationForCaseInstancesOfCaseDefinition(caseDefinitionId, this.getCaseInstanceMigrationDocument());
    }

    public void migrateCaseInstances(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        this.getCmmnMigrationService().migrateCaseInstancesOfCaseDefinition(caseDefinitionKey, caseDefinitionVersion, caseDefinitionTenantId, this.getCaseInstanceMigrationDocument());
    }

    public Batch batchMigrateCaseInstances(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        return this.getCmmnMigrationService().batchMigrateCaseInstancesOfCaseDefinition(caseDefinitionKey, caseDefinitionVersion, caseDefinitionTenantId, this.getCaseInstanceMigrationDocument());
    }

    public CaseInstanceMigrationValidationResult validateMigrationOfCaseInstances(String caseDefinitionKey, int caseDefinitionVersion, String caseDefinitionTenantId) {
        return this.getCmmnMigrationService().validateMigrationForCaseInstancesOfCaseDefinition(caseDefinitionKey, caseDefinitionVersion, caseDefinitionTenantId, this.getCaseInstanceMigrationDocument());
    }

    protected CmmnMigrationService getCmmnMigrationService() {
        if (this.cmmnMigrationService == null) {
            throw new FlowableException("CaseMigrationService cannot be null, Obtain your builder instance from the CaseMigrationService to access this feature");
        }
        return this.cmmnMigrationService;
    }
}

