/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.job;

import com.fasterxml.jackson.databind.JsonNode;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CmmnLoggingSessionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncLeaveActivePlanItemInstanceJobHandler
implements JobHandler {
    public static final String TYPE = "cmmn-async-leave-active-plan-item-instance";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        if (variableScope instanceof PlanItemInstanceEntity) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)variableScope;
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            if (cmmnEngineConfiguration.isLoggingSessionEnabled()) {
                CmmnLoggingSessionUtil.addAsyncActivityLoggingData("Executing async job for " + planItemInstanceEntity.getPlanItemDefinitionId() + ", with job id " + job.getId(), "serviceTaskExecuteAsyncJob", job, planItemInstanceEntity.getPlanItemDefinition(), planItemInstanceEntity, cmmnEngineConfiguration.getObjectMapper());
            }
            try {
                JsonNode jsonConfiguration = cmmnEngineConfiguration.getObjectMapper().readTree(configuration);
                String transition = jsonConfiguration.get("operationTransition").asText();
                if ("complete".equals(transition)) {
                    CommandContextUtil.getAgenda(commandContext).planCompletePlanItemInstanceOperation(planItemInstanceEntity);
                }
                if ("exit".equals(transition)) {
                    String exitCriterionId = jsonConfiguration.path("exitCriterionId").asText(null);
                    String exitType = jsonConfiguration.path("exitType").asText(null);
                    String exitEventType = jsonConfiguration.path("exitEventType").asText(null);
                    CommandContextUtil.getAgenda(commandContext).planExitPlanItemInstanceOperation(planItemInstanceEntity, exitCriterionId, exitType, exitEventType);
                }
                if ("terminate".equals(transition)) {
                    String exitType = jsonConfiguration.path("exitType").asText(null);
                    String exitEventType = jsonConfiguration.path("exitEventType").asText(null);
                    CommandContextUtil.getAgenda(commandContext).planTerminatePlanItemInstanceOperation(planItemInstanceEntity, exitType, exitEventType);
                }
                throw new FlowableException("Programmatic error: unsupported transition " + transition + " for " + planItemInstanceEntity);
            }
            catch (Exception e) {
                throw new FlowableException("Could not deserialize job configuration", (Throwable)e);
            }
        } else {
            throw new FlowableException("Invalid usage of cmmn-async-leave-active-plan-item-instance job handler, variable scope is of type " + variableScope.getClass());
        }
    }
}

