/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.eventregistry;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.flowable.cmmn.api.CmmnRuntimeService;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.api.runtime.CaseInstanceBuilder;
import org.flowable.cmmn.api.runtime.CaseInstanceQuery;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.eventregistry.api.EventConsumerInfo;
import org.flowable.eventregistry.api.EventRegistryProcessingInfo;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.consumer.BaseEventRegistryEventConsumer;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmmnEventRegistryEventConsumer
extends BaseEventRegistryEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmmnEventRegistryEventConsumer.class);
    protected CmmnEngineConfiguration cmmnEngineConfiguration;

    public CmmnEventRegistryEventConsumer(CmmnEngineConfiguration cmmnEngineConfiguration) {
        super((AbstractEngineConfiguration)cmmnEngineConfiguration);
        this.cmmnEngineConfiguration = cmmnEngineConfiguration;
    }

    public String getConsumerKey() {
        return "cmmnEventConsumer";
    }

    protected EventRegistryProcessingInfo eventReceived(EventInstance eventInstance) {
        EventRegistryProcessingInfo eventRegistryProcessingInfo = new EventRegistryProcessingInfo();
        Collection correlationKeys = this.generateCorrelationKeys(eventInstance.getCorrelationParameterInstances());
        List eventSubscriptions = this.findEventSubscriptions("cmmn", eventInstance, correlationKeys);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Found {} for {}", (Object)eventSubscriptions, (Object)eventInstance);
        }
        CmmnRuntimeService cmmnRuntimeService = this.cmmnEngineConfiguration.getCmmnRuntimeService();
        for (EventSubscription eventSubscription : eventSubscriptions) {
            EventConsumerInfo eventConsumerInfo;
            boolean eventSubscriptionHandled = this.handleEventSubscription(cmmnRuntimeService, eventSubscription, eventInstance, correlationKeys, eventConsumerInfo = new EventConsumerInfo(eventSubscription.getId(), eventSubscription.getSubScopeId(), eventSubscription.getScopeDefinitionId(), "cmmn"));
            if (!eventSubscriptionHandled) continue;
            eventRegistryProcessingInfo.addEventConsumerInfo(eventConsumerInfo);
        }
        return eventRegistryProcessingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleEventSubscription(CmmnRuntimeService cmmnRuntimeService, EventSubscription eventSubscription, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys, EventConsumerInfo eventConsumerInfo) {
        String startCorrelationConfiguration;
        String planItemInstanceId = eventSubscription.getSubScopeId();
        if (planItemInstanceId != null) {
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnRuntimeService.createPlanItemInstanceQuery().planItemInstanceId(planItemInstanceId).singleResult();
            CmmnModel cmmnModel = this.cmmnEngineConfiguration.getCmmnRepositoryService().getCmmnModel(planItemInstanceEntity.getCaseDefinitionId());
            PlanItem planItem = cmmnModel.findPlanItemByPlanItemDefinitionId(planItemInstanceEntity.getPlanItemDefinitionId());
            if ("active".equals(planItemInstanceEntity.getState()) || planItem != null && planItem.getPlanItemDefinition() instanceof EventListener && "available".equals(planItemInstanceEntity.getState())) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Triggering {} with {}", (Object)planItemInstanceEntity, (Object)eventInstance);
                }
                cmmnRuntimeService.createPlanItemInstanceTransitionBuilder(planItemInstanceId).transientVariable("eventInstance", (Object)eventInstance).trigger();
                return true;
            }
            if (!LOGGER.isDebugEnabled()) return false;
            LOGGER.debug("Ignoring {} because {} was not in the right state", (Object)eventInstance, (Object)planItemInstanceEntity);
            return false;
        }
        if (eventSubscription.getScopeDefinitionId() == null) return true;
        if (eventSubscription.getScopeId() != null) return true;
        if (correlationKeys != null && Objects.equals(startCorrelationConfiguration = this.getStartCorrelationConfiguration(eventSubscription), "storeAsUniqueReferenceId")) {
            CaseDefinition caseDefinition;
            CorrelationKey correlationKeyWithAllParameters = this.getCorrelationKeyWithAllParameters(correlationKeys);
            long caseInstanceCount = this.countCaseInstances(cmmnRuntimeService, eventInstance, correlationKeyWithAllParameters, caseDefinition = this.cmmnEngineConfiguration.getCmmnRepositoryService().getCaseDefinition(eventSubscription.getScopeDefinitionId()));
            if (caseInstanceCount > 0L) {
                eventConsumerInfo.setHasExistingInstancesForUniqueCorrelation(true);
                LOGGER.debug("Event received to start a new case instance, but a unique instance already exists.");
                return true;
            }
            if (!this.cmmnEngineConfiguration.isEventRegistryUniqueCaseInstanceCheckWithLock()) {
                this.startCaseInstance(cmmnRuntimeService, eventSubscription, eventInstance, correlationKeyWithAllParameters);
                return true;
            }
            String countLockName = "celock" + correlationKeyWithAllParameters.getValue() + caseDefinition.getKey();
            LockManager lockManager = this.cmmnEngineConfiguration.getLockManager(countLockName);
            boolean lockAcquired = lockManager.acquireLock(this.cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionLockTime());
            if (!lockAcquired) {
                LOGGER.info("Lock for {} was not acquired. This means that another event has already acquired that lock and will start a new case instance. Ignoring this one.", (Object)countLockName);
                return true;
            }
            try {
                caseInstanceCount = this.countCaseInstances(cmmnRuntimeService, eventInstance, correlationKeyWithAllParameters, caseDefinition);
                if (caseInstanceCount > 0L) {
                    eventConsumerInfo.setHasExistingInstancesForUniqueCorrelation(true);
                    LOGGER.debug("Event received to start a new case instance, but a unique instance already exists.");
                    boolean bl = true;
                    return bl;
                }
                this.startCaseInstance(cmmnRuntimeService, eventSubscription, eventInstance, correlationKeyWithAllParameters);
                boolean bl = true;
                return bl;
            }
            finally {
                lockManager.releaseAndDeleteLock();
            }
        }
        this.startCaseInstance(cmmnRuntimeService, eventSubscription, eventInstance, null);
        return true;
    }

    protected long countCaseInstances(CmmnRuntimeService cmmnRuntimeService, EventInstance eventInstance, CorrelationKey correlationKey, CaseDefinition caseDefinition) {
        CaseInstanceQuery caseInstanceQuery = cmmnRuntimeService.createCaseInstanceQuery().caseDefinitionKey(caseDefinition.getKey()).caseInstanceReferenceId(correlationKey.getValue()).caseInstanceReferenceType("event-to-cmmn-1.1-case");
        if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
            caseInstanceQuery.caseInstanceTenantId(eventInstance.getTenantId());
        }
        return caseInstanceQuery.count();
    }

    protected void startCaseInstance(CmmnRuntimeService cmmnRuntimeService, EventSubscription eventSubscription, EventInstance eventInstance, CorrelationKey correlationKey) {
        CaseInstanceBuilder caseInstanceBuilder = cmmnRuntimeService.createCaseInstanceBuilder().caseDefinitionId(eventSubscription.getScopeDefinitionId()).transientVariable("eventInstance", (Object)eventInstance);
        if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
            caseInstanceBuilder.overrideCaseDefinitionTenantId(eventInstance.getTenantId());
        }
        if (correlationKey != null) {
            caseInstanceBuilder.referenceId(correlationKey.getValue()).referenceType("event-to-cmmn-1.1-case");
        }
        boolean debugLoggingEnabled = LOGGER.isDebugEnabled();
        if (this.cmmnEngineConfiguration.isEventRegistryStartCaseInstanceAsync()) {
            if (debugLoggingEnabled) {
                LOGGER.debug("Async starting case instance for {} with {}", (Object)eventSubscription, (Object)eventInstance);
            }
            CaseInstance caseInstance = caseInstanceBuilder.startAsync();
            if (debugLoggingEnabled) {
                LOGGER.debug("Started {} async for {} with {}", new Object[]{caseInstance, eventSubscription, eventInstance});
            }
        } else {
            if (debugLoggingEnabled) {
                LOGGER.debug("Starting case instance for {} with {}", (Object)eventSubscription, (Object)eventInstance);
            }
            CaseInstance caseInstance = caseInstanceBuilder.start();
            if (debugLoggingEnabled) {
                LOGGER.debug("Started {} for {} with {}", new Object[]{caseInstance, eventSubscription, eventInstance});
            }
        }
    }

    protected String getStartCorrelationConfiguration(EventSubscription eventSubscription) {
        List correlationCfgExtensions;
        CmmnModel cmmnModel = this.cmmnEngineConfiguration.getCmmnRepositoryService().getCmmnModel(eventSubscription.getScopeDefinitionId());
        if (cmmnModel != null && !(correlationCfgExtensions = cmmnModel.getPrimaryCase().getExtensionElements().getOrDefault("startEventCorrelationConfiguration", Collections.emptyList())).isEmpty()) {
            return ((ExtensionElement)correlationCfgExtensions.get(0)).getElementText();
        }
        return null;
    }

    protected EventSubscriptionQuery createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.commandExecutor, this.cmmnEngineConfiguration.getEventSubscriptionServiceConfiguration());
    }
}

