/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.cmmn.api.runtime.CaseInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetCaseInstanceBusinessStatusCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String caseInstanceId;
    private final String businessStatus;

    public SetCaseInstanceBusinessStatusCmd(String caseInstanceId, String businessStatus) {
        if (caseInstanceId == null || caseInstanceId.length() < 1) {
            throw new FlowableIllegalArgumentException("The case instance id is mandatory, but '" + caseInstanceId + "' has not been provided.");
        }
        this.caseInstanceId = caseInstanceId;
        this.businessStatus = businessStatus;
    }

    public Void execute(CommandContext commandContext) {
        CaseInstanceEntityManager caseInstanceEntityManager = CommandContextUtil.getCaseInstanceEntityManager(commandContext);
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)caseInstanceEntityManager.findById(this.caseInstanceId);
        if (caseInstanceEntity == null) {
            throw new FlowableObjectNotFoundException("No case instance found for id = '" + this.caseInstanceId + "'.", CaseInstance.class);
        }
        caseInstanceEntityManager.updateCaseInstanceBusinessStatus(caseInstanceEntity, this.businessStatus);
        return null;
    }
}

