/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.api.FormInstanceInfo;
import org.flowable.form.api.FormService;

public class GetStartFormModelCmd
implements Command<FormInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String caseInstanceId;

    public GetStartFormModelCmd(String caseDefinitionId, String caseInstanceId) {
        this.caseDefinitionId = caseDefinitionId;
        this.caseInstanceId = caseInstanceId;
    }

    public FormInfo execute(CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        FormService formService = CommandContextUtil.getFormService(commandContext);
        if (formService == null) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        FormInstanceInfo formInfo = null;
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(this.caseDefinitionId);
        CmmnModel cmmnModel = CaseDefinitionUtil.getCmmnModel(this.caseDefinitionId);
        Case caseModel = cmmnModel.getCaseById(caseDefinition.getKey());
        Stage planModel = caseModel.getPlanModel();
        if (StringUtils.isNotEmpty((CharSequence)planModel.getFormKey())) {
            CmmnDeployment deployment = (CmmnDeployment)CommandContextUtil.getCmmnDeploymentEntityManager(commandContext).findById(caseDefinition.getDeploymentId());
            formInfo = formService.getFormInstanceModelByKeyAndParentDeploymentIdAndScopeId(planModel.getFormKey(), deployment.getParentDeploymentId(), this.caseInstanceId, "cmmn", null, caseDefinition.getTenantId(), cmmnEngineConfiguration.isFallbackToDefaultTenant());
        }
        if (formInfo == null) {
            throw new FlowableObjectNotFoundException("Form model for case definition " + this.caseDefinitionId + " cannot be found");
        }
        FormFieldHandler formFieldHandler = cmmnEngineConfiguration.getFormFieldHandler();
        formFieldHandler.enrichFormFields(formInfo);
        return formInfo;
    }
}

