/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flowable.cmmn.api.repository.CaseDefinition;
import org.flowable.cmmn.api.repository.CmmnDeployment;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.DecisionTask;
import org.flowable.cmmn.model.FieldExtension;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.dmn.api.DmnDecision;
import org.flowable.dmn.api.DmnDecisionQuery;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnRepositoryService;

public class GetDecisionsForCaseDefinitionCmd
implements Command<List<DmnDecision>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected DmnRepositoryService dmnRepositoryService;

    public GetDecisionsForCaseDefinitionCmd(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    public List<DmnDecision> execute(CommandContext commandContext) {
        CaseDefinition caseDefinition = CaseDefinitionUtil.getCaseDefinition(this.caseDefinitionId);
        if (caseDefinition == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, CaseDefinition.class);
        }
        Case caseModel = CaseDefinitionUtil.getCase(this.caseDefinitionId);
        if (caseModel == null) {
            throw new FlowableObjectNotFoundException("Cannot find case definition for id: " + this.caseDefinitionId, Case.class);
        }
        this.dmnRepositoryService = CommandContextUtil.getDmnEngineConfiguration(commandContext).getDmnRepositoryService();
        if (this.dmnRepositoryService == null) {
            throw new FlowableException("DMN repository service is not available");
        }
        List<DmnDecision> decision = this.getDecisionsFromModel(caseModel, caseDefinition);
        return decision;
    }

    protected List<DmnDecision> getDecisionsFromModel(Case caseModel, CaseDefinition caseDefinition) {
        HashSet<String> decisionKeys = new HashSet<String>();
        ArrayList<DmnDecision> decisions = new ArrayList<DmnDecision>();
        List decisionTasks = caseModel.getPlanModel().findPlanItemDefinitionsOfType(DecisionTask.class, true);
        block0: for (DecisionTask decisionTask : decisionTasks) {
            if (decisionTask.getFieldExtensions() == null || decisionTask.getFieldExtensions().size() <= 0) continue;
            for (FieldExtension fieldExtension : decisionTask.getFieldExtensions()) {
                if (!"decisionTableReferenceKey".equals(fieldExtension.getFieldName())) continue;
                String decisionReferenceKey = fieldExtension.getStringValue();
                if (decisionKeys.contains(decisionReferenceKey)) continue block0;
                this.addDecisionToCollection(decisions, decisionReferenceKey, caseDefinition);
                decisionKeys.add(decisionReferenceKey);
                continue block0;
            }
        }
        return decisions;
    }

    protected void addDecisionToCollection(List<DmnDecision> decisions, String decisionKey, CaseDefinition caseDefinition) {
        DmnDecisionQuery definitionQuery = this.dmnRepositoryService.createDecisionQuery().decisionKey(decisionKey);
        CmmnDeployment deployment = (CmmnDeployment)CommandContextUtil.getCmmnDeploymentEntityManager().findById(caseDefinition.getDeploymentId());
        if (deployment.getParentDeploymentId() != null) {
            List dmnDeployments = this.dmnRepositoryService.createDeploymentQuery().parentDeploymentId(deployment.getParentDeploymentId()).list();
            if (dmnDeployments != null && dmnDeployments.size() > 0) {
                definitionQuery.deploymentId(((DmnDeployment)dmnDeployments.get(0)).getId());
            } else {
                definitionQuery.latestVersion();
            }
        } else {
            definitionQuery.latestVersion();
        }
        DmnDecision decision = (DmnDecision)definitionQuery.singleResult();
        if (decision != null) {
            decisions.add(decision);
        }
    }
}

