/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.callback;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.process.ProcessInstanceService;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.IOParameter;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.callback.CallbackData;
import org.flowable.common.engine.impl.callback.RuntimeInstanceStateChangeCallback;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildBpmnCaseInstanceStateChangeCallback
implements RuntimeInstanceStateChangeCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildBpmnCaseInstanceStateChangeCallback.class);

    public void stateChanged(CallbackData callbackData) {
        if ("terminated".equals(callbackData.getNewState()) || "completed".equals(callbackData.getNewState())) {
            CommandContext commandContext = CommandContextUtil.getCommandContext();
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            CaseInstanceEntity caseInstance = (CaseInstanceEntity)cmmnEngineConfiguration.getCaseInstanceEntityManager().findById(callbackData.getInstanceId());
            ProcessInstanceService processInstanceService = cmmnEngineConfiguration.getProcessInstanceService();
            HashMap<String, Object> variables = new HashMap<String, Object>();
            for (IOParameter outParameter : processInstanceService.getOutputParametersOfCaseTask(callbackData.getCallbackId())) {
                Object value = null;
                if (StringUtils.isNotEmpty((CharSequence)outParameter.getSourceExpression())) {
                    Expression expression = cmmnEngineConfiguration.getExpressionManager().createExpression(outParameter.getSourceExpression().trim());
                    value = expression.getValue((VariableContainer)caseInstance);
                } else {
                    value = caseInstance.getVariable(outParameter.getSource());
                }
                String variableName = null;
                if (StringUtils.isNotEmpty((CharSequence)outParameter.getTarget())) {
                    variableName = outParameter.getTarget();
                } else if (StringUtils.isNotEmpty((CharSequence)outParameter.getTargetExpression())) {
                    Object variableNameValue = cmmnEngineConfiguration.getExpressionManager().createExpression(outParameter.getTargetExpression()).getValue((VariableContainer)caseInstance);
                    if (variableNameValue != null) {
                        variableName = variableNameValue.toString();
                    } else {
                        LOGGER.warn("Out parameter target expression {} did not resolve to a variable name, this is most likely a programmatic error", (Object)outParameter.getTargetExpression());
                    }
                }
                variables.put(variableName, value);
            }
            processInstanceService.triggerCaseTask(callbackData.getCallbackId(), variables);
        }
    }
}

