/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.behavior.impl;

import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.behavior.CoreCmmnActivityBehavior;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.MilestoneInstanceEntityManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class MilestoneActivityBehavior
extends CoreCmmnActivityBehavior {
    protected Expression milestoneNameExpression;
    protected String milestoneVariable;
    protected String businessStatus;

    public MilestoneActivityBehavior(Expression milestoneNameExpression, String milestoneVariable, String businessStatus) {
        this.milestoneNameExpression = milestoneNameExpression;
        this.milestoneVariable = milestoneVariable;
        this.businessStatus = businessStatus;
    }

    @Override
    public void execute(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        Expression businessStatusExpression;
        String actualBusinessStatus;
        Expression milestoneVariableExpression;
        String actualMilestoneVariable;
        MilestoneInstanceEntity milestoneInstanceEntity = this.createMilestoneInstance(planItemInstanceEntity, commandContext);
        ExpressionManager expressionManager = CommandContextUtil.getExpressionManager(commandContext);
        if (StringUtils.isNotEmpty((CharSequence)this.milestoneVariable) && StringUtils.isNotEmpty((CharSequence)(actualMilestoneVariable = (String)(milestoneVariableExpression = expressionManager.createExpression(this.milestoneVariable)).getValue((VariableContainer)planItemInstanceEntity)))) {
            planItemInstanceEntity.setVariable(actualMilestoneVariable, true);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.businessStatus) && StringUtils.isNotEmpty((CharSequence)(actualBusinessStatus = (String)(businessStatusExpression = expressionManager.createExpression(this.businessStatus)).getValue((VariableContainer)planItemInstanceEntity)))) {
            CommandContextUtil.getCmmnRuntimeService().updateBusinessStatus(milestoneInstanceEntity.getCaseInstanceId(), actualBusinessStatus);
        }
        CommandContextUtil.getCmmnHistoryManager(commandContext).recordMilestoneReached(milestoneInstanceEntity);
        CommandContextUtil.getAgenda(commandContext).planOccurPlanItemInstanceOperation(planItemInstanceEntity);
    }

    protected MilestoneInstanceEntity createMilestoneInstance(PlanItemInstanceEntity planItemInstanceEntity, CommandContext commandContext) {
        CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
        MilestoneInstanceEntityManager milestoneInstanceEntityManager = cmmnEngineConfiguration.getMilestoneInstanceEntityManager();
        MilestoneInstanceEntity milestoneInstanceEntity = (MilestoneInstanceEntity)milestoneInstanceEntityManager.create();
        milestoneInstanceEntity.setName(this.milestoneNameExpression.getValue((VariableContainer)planItemInstanceEntity).toString());
        milestoneInstanceEntity.setTimeStamp(CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime());
        milestoneInstanceEntity.setCaseInstanceId(planItemInstanceEntity.getCaseInstanceId());
        milestoneInstanceEntity.setCaseDefinitionId(planItemInstanceEntity.getCaseDefinitionId());
        milestoneInstanceEntity.setElementId(planItemInstanceEntity.getElementId());
        milestoneInstanceEntity.setTenantId(planItemInstanceEntity.getTenantId());
        milestoneInstanceEntityManager.insert(milestoneInstanceEntity);
        return milestoneInstanceEntity;
    }
}

