/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import org.flowable.cmmn.engine.impl.agenda.operation.AbstractChangePlanItemInstanceStateOperation;
import org.flowable.cmmn.engine.impl.history.CmmnHistoryManager;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.ReactivateEventListener;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class ReactivatePlanItemInstanceOperation
extends AbstractChangePlanItemInstanceStateOperation {
    public ReactivatePlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext, planItemInstanceEntity);
    }

    @Override
    protected void internalExecute() {
        CmmnHistoryManager cmmnHistoryManager = CommandContextUtil.getCmmnHistoryManager(this.commandContext);
        cmmnHistoryManager.recordPlanItemInstanceReactivated(this.planItemInstanceEntity);
        if (this.getNewState().equals("available")) {
            this.planItemInstanceEntity.setLastAvailableTime(this.getCurrentTime(this.commandContext));
            cmmnHistoryManager.recordPlanItemInstanceAvailable(this.planItemInstanceEntity);
        }
    }

    @Override
    public String getNewState() {
        if (this.isEventListenerWithAvailableCondition(this.planItemInstanceEntity.getPlanItem())) {
            if (this.planItemInstanceEntity.getPlanItemDefinition() != null && this.planItemInstanceEntity.getPlanItemDefinition() instanceof ReactivateEventListener) {
                return "available";
            }
            return "unavailable";
        }
        return "available";
    }

    @Override
    public String getLifeCycleTransition() {
        return "reactivate";
    }

    @Override
    public String getOperationName() {
        return "[Reactivate plan item]";
    }
}

