/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda;

import java.util.ArrayList;
import java.util.List;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;

public class PlanItemEvaluationResult {
    List<PlanItemInstanceEntity> allChildPlanItemInstances;
    int activeChildren = 0;
    boolean criteriaChanged = false;
    List<PlanItemInstanceEntity> newChildPlanItemInstances = null;

    public PlanItemEvaluationResult() {
    }

    public PlanItemEvaluationResult(List<PlanItemInstanceEntity> allChildPlanItemInstances) {
        this.allChildPlanItemInstances = allChildPlanItemInstances;
    }

    public void increaseActiveChildren() {
        ++this.activeChildren;
    }

    public void addChildPlanItemInstance(PlanItemInstanceEntity planItemInstanceEntity) {
        if (this.newChildPlanItemInstances == null) {
            this.newChildPlanItemInstances = new ArrayList<PlanItemInstanceEntity>();
        }
        this.newChildPlanItemInstances.add(planItemInstanceEntity);
    }

    public void markCriteriaChanged() {
        this.criteriaChanged = true;
    }

    public int getActiveChildren() {
        return this.activeChildren;
    }

    public boolean isCriteriaChanged() {
        return this.criteriaChanged;
    }

    public boolean hasNewChildPlanItemInstances() {
        return this.newChildPlanItemInstances != null && this.newChildPlanItemInstances.size() > 0;
    }

    public List<PlanItemInstanceEntity> getNewChildPlanItemInstances() {
        return this.newChildPlanItemInstances;
    }

    public boolean criteriaChangedOrNewActiveChildren() {
        return this.criteriaChanged || this.activeChildren > 0;
    }

    public List<PlanItemInstanceEntity> getAllChildPlanItemInstances() {
        return this.allChildPlanItemInstances;
    }

    public boolean hasCompletedPlanItemInstance(PlanItemInstanceEntity planItemInstance) {
        if (this.allChildPlanItemInstances == null || this.allChildPlanItemInstances.size() == 0) {
            return false;
        }
        for (PlanItemInstanceEntity childPlanItemInstance : this.allChildPlanItemInstances) {
            if (!childPlanItemInstance.getPlanItemDefinitionId().equals(planItemInstance.getPlanItemDefinitionId()) || !"completed".equals(childPlanItemInstance.getState())) continue;
            return true;
        }
        return false;
    }
}

