/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.export.CriteriaExport;
import org.flowable.cmmn.converter.export.PlanItemControlExport;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.PlanItemControl;

public class PlanItemExport
implements CmmnXmlConstants {
    public static void writePlanItem(CmmnModel model, PlanItem planItem, XMLStreamWriter xtw) throws Exception {
        boolean didWriteExtensionElement;
        xtw.writeStartElement("planItem");
        xtw.writeAttribute("id", planItem.getId());
        if (StringUtils.isNotEmpty((CharSequence)planItem.getName())) {
            xtw.writeAttribute("name", planItem.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)planItem.getDefinitionRef())) {
            xtw.writeAttribute("definitionRef", planItem.getDefinitionRef());
        }
        if (StringUtils.isNotEmpty((CharSequence)planItem.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(planItem.getDocumentation());
            xtw.writeEndElement();
        }
        if (didWriteExtensionElement = CmmnXmlUtil.writeExtensionElements((BaseElement)planItem, false, model.getNamespaces(), xtw)) {
            xtw.writeEndElement();
        }
        if (planItem.getItemControl() != null) {
            PlanItemControl itemControl = planItem.getItemControl();
            PlanItemControlExport.writeItemControl(model, itemControl, xtw);
        }
        CriteriaExport.writeCriteriaElements(planItem, xtw);
        xtw.writeEndElement();
    }
}

