/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.converter.export;

import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.converter.CmmnXmlConstants;
import org.flowable.cmmn.converter.util.CmmnXmlUtil;
import org.flowable.cmmn.model.Case;

public class CaseExport
implements CmmnXmlConstants {
    public static void writeCase(Case caseModel, XMLStreamWriter xtw) throws Exception {
        xtw.writeStartElement("case");
        xtw.writeAttribute("id", caseModel.getId());
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getName())) {
            xtw.writeAttribute("name", caseModel.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getInitiatorVariableName())) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "initiatorVariableName", caseModel.getInitiatorVariableName());
        }
        if (!caseModel.getCandidateStarterUsers().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateStarterUsers", CmmnXmlUtil.convertToDelimitedString(caseModel.getCandidateStarterUsers()));
        }
        if (!caseModel.getCandidateStarterGroups().isEmpty()) {
            xtw.writeAttribute("flowable", "http://flowable.org/cmmn", "candidateStarterGroups", CmmnXmlUtil.convertToDelimitedString(caseModel.getCandidateStarterGroups()));
        }
        if (StringUtils.isNotEmpty((CharSequence)caseModel.getDocumentation())) {
            xtw.writeStartElement("documentation");
            xtw.writeCharacters(caseModel.getDocumentation());
            xtw.writeEndElement();
        }
    }
}

