/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.api.migration;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.flowable.cmmn.api.migration.CaseInstanceBatchMigrationPartResult;

public class CaseInstanceBatchMigrationResult {
    public static final String STATUS_IN_PROGRESS = "inProgress";
    public static final String STATUS_WAITING = "waiting";
    public static final String STATUS_COMPLETED = "completed";
    public static final String RESULT_SUCCESS = "success";
    public static final String RESULT_FAIL = "fail";
    protected String batchId;
    protected String status;
    protected Date completeTime;
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<CaseInstanceBatchMigrationPartResult> allMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
    protected List<CaseInstanceBatchMigrationPartResult> succesfulMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
    protected List<CaseInstanceBatchMigrationPartResult> failedMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
    protected List<CaseInstanceBatchMigrationPartResult> waitingMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Date getCompleteTime() {
        return this.completeTime;
    }

    public void setCompleteTime(Date completeTime) {
        this.completeTime = completeTime;
    }

    public String getSourceCaseDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public void setSourceCaseDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public String getTargetCaseDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public void setTargetCaseDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public List<CaseInstanceBatchMigrationPartResult> getAllMigrationParts() {
        return this.allMigrationParts;
    }

    public void addMigrationPart(CaseInstanceBatchMigrationPartResult migrationPart) {
        if (this.allMigrationParts == null) {
            this.allMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
        }
        this.allMigrationParts.add(migrationPart);
        if (!STATUS_COMPLETED.equals(migrationPart.getStatus())) {
            if (this.waitingMigrationParts == null) {
                this.waitingMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
            }
            this.waitingMigrationParts.add(migrationPart);
        } else if (RESULT_SUCCESS.equals(migrationPart.getResult())) {
            if (this.succesfulMigrationParts == null) {
                this.succesfulMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
            }
            this.succesfulMigrationParts.add(migrationPart);
        } else {
            if (this.failedMigrationParts == null) {
                this.failedMigrationParts = new ArrayList<CaseInstanceBatchMigrationPartResult>();
            }
            this.failedMigrationParts.add(migrationPart);
        }
    }

    public List<CaseInstanceBatchMigrationPartResult> getSuccessfulMigrationParts() {
        return this.succesfulMigrationParts;
    }

    public List<CaseInstanceBatchMigrationPartResult> getFailedMigrationParts() {
        return this.failedMigrationParts;
    }

    public List<CaseInstanceBatchMigrationPartResult> getWaitingMigrationParts() {
        return this.waitingMigrationParts;
    }
}

