/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.validation;

import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.validation.validator.ValidationEntry;

public interface CaseValidationContext {
    default public ValidationEntry addError(String problem, String description) {
        return this.addError(problem, null, null, null, description);
    }

    default public ValidationEntry addError(String problem, Case caze, CaseElement caseElement, BaseElement baseElement, String description) {
        return this.addEntry(problem, caze, caseElement, baseElement, description, ValidationEntry.Level.Error);
    }

    default public ValidationEntry addWarning(String problem, String description) {
        return this.addWarning(problem, null, null, null, description);
    }

    default public ValidationEntry addWarning(String problem, Case caze, CaseElement caseElement, BaseElement baseElement, String description) {
        return this.addEntry(problem, caze, caseElement, baseElement, description, ValidationEntry.Level.Warning);
    }

    default public ValidationEntry addEntry(String problem, Case caze, CaseElement caseElement, BaseElement baseElement, String description, ValidationEntry.Level level) {
        ValidationEntry entry = new ValidationEntry();
        entry.setLevel(level);
        if (caze != null) {
            entry.setCaseDefinitionId(caze.getId());
            entry.setCaseDefinitionName(caze.getName());
        }
        if (baseElement != null) {
            entry.setXmlLineNumber(baseElement.getXmlRowNumber());
            entry.setXmlColumnNumber(baseElement.getXmlColumnNumber());
        }
        entry.setProblem(problem);
        entry.setDefaultDescription(description);
        if (caseElement == null && baseElement instanceof CaseElement) {
            caseElement = (CaseElement)baseElement;
        }
        if (caseElement != null) {
            entry.setItemId(caseElement.getId());
            entry.setItemName(caseElement.getName());
        }
        return this.addEntry(entry);
    }

    public ValidationEntry addEntry(ValidationEntry var1);
}

