/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Artifact;
import org.flowable.bpmn.model.Association;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.HasExecutionListeners;
import org.flowable.bpmn.model.IOSpecification;
import org.flowable.bpmn.model.Lane;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;

public class Process
extends BaseElement
implements FlowElementsContainer,
HasExecutionListeners {
    protected String name;
    protected boolean executable = true;
    protected String documentation;
    protected IOSpecification ioSpecification;
    protected List<FlowableListener> executionListeners = new ArrayList<FlowableListener>();
    protected List<Lane> lanes = new ArrayList<Lane>();
    protected List<FlowElement> flowElementList = new ArrayList<FlowElement>();
    protected List<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();
    protected List<Artifact> artifactList = new ArrayList<Artifact>();
    protected List<String> candidateStarterUsers = new ArrayList<String>();
    protected List<String> candidateStarterGroups = new ArrayList<String>();
    protected List<EventListener> eventListeners = new ArrayList<EventListener>();
    protected Map<String, FlowElement> flowElementMap = new LinkedHashMap<String, FlowElement>();
    protected FlowElement initialFlowElement;
    protected boolean enableEagerExecutionTreeFetching;

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public void setExecutable(boolean executable) {
        this.executable = executable;
    }

    public IOSpecification getIoSpecification() {
        return this.ioSpecification;
    }

    public void setIoSpecification(IOSpecification ioSpecification) {
        this.ioSpecification = ioSpecification;
    }

    @Override
    public List<FlowableListener> getExecutionListeners() {
        return this.executionListeners;
    }

    @Override
    public void setExecutionListeners(List<FlowableListener> executionListeners) {
        this.executionListeners = executionListeners;
    }

    public List<Lane> getLanes() {
        return this.lanes;
    }

    public void setLanes(List<Lane> lanes) {
        this.lanes = lanes;
    }

    @Override
    public Map<String, FlowElement> getFlowElementMap() {
        return this.flowElementMap;
    }

    public void setFlowElementMap(Map<String, FlowElement> flowElementMap) {
        this.flowElementMap = flowElementMap;
    }

    public boolean containsFlowElementId(String id) {
        return this.flowElementMap.containsKey(id);
    }

    @Override
    public FlowElement getFlowElement(String flowElementId) {
        return this.getFlowElement(flowElementId, false);
    }

    public FlowElement getFlowElement(String flowElementId, boolean searchRecursive) {
        if (searchRecursive) {
            return this.flowElementMap.get(flowElementId);
        }
        return this.findFlowElementInList(flowElementId);
    }

    public List<Association> findAssociationsWithSourceRefRecursive(String sourceRef) {
        return this.findAssociationsWithSourceRefRecursive(this, sourceRef);
    }

    protected List<Association> findAssociationsWithSourceRefRecursive(FlowElementsContainer flowElementsContainer, String sourceRef) {
        ArrayList<Association> associations = new ArrayList<Association>();
        for (Artifact artifact : flowElementsContainer.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || (association = (Association)artifact).getSourceRef() == null || association.getTargetRef() == null || !association.getSourceRef().equals(sourceRef)) continue;
            associations.add(association);
        }
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            associations.addAll(this.findAssociationsWithSourceRefRecursive((FlowElementsContainer)((Object)flowElement), sourceRef));
        }
        return associations;
    }

    public List<Association> findAssociationsWithTargetRefRecursive(String targetRef) {
        return this.findAssociationsWithTargetRefRecursive(this, targetRef);
    }

    protected List<Association> findAssociationsWithTargetRefRecursive(FlowElementsContainer flowElementsContainer, String targetRef) {
        ArrayList<Association> associations = new ArrayList<Association>();
        for (Artifact artifact : flowElementsContainer.getArtifacts()) {
            Association association;
            if (!(artifact instanceof Association) || (association = (Association)artifact).getTargetRef() == null || !association.getTargetRef().equals(targetRef)) continue;
            associations.add(association);
        }
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            if (!(flowElement instanceof FlowElementsContainer)) continue;
            associations.addAll(this.findAssociationsWithTargetRefRecursive((FlowElementsContainer)((Object)flowElement), targetRef));
        }
        return associations;
    }

    public FlowElementsContainer getFlowElementsContainer(String flowElementId) {
        return this.getFlowElementsContainer(this, flowElementId);
    }

    protected FlowElementsContainer getFlowElementsContainer(FlowElementsContainer flowElementsContainer, String flowElementId) {
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            FlowElementsContainer result;
            if (flowElement.getId() != null && flowElement.getId().equals(flowElementId)) {
                return flowElementsContainer;
            }
            if (!(flowElement instanceof FlowElementsContainer) || (result = this.getFlowElementsContainer((FlowElementsContainer)((Object)flowElement), flowElementId)) == null) continue;
            return result;
        }
        return null;
    }

    protected FlowElement findFlowElementInList(String flowElementId) {
        for (FlowElement f : this.flowElementList) {
            if (f.getId() == null || !f.getId().equals(flowElementId)) continue;
            return f;
        }
        return null;
    }

    @Override
    public Collection<FlowElement> getFlowElements() {
        return this.flowElementList;
    }

    @Override
    public void addFlowElement(FlowElement element) {
        this.flowElementList.add(element);
        element.setParentContainer(this);
        this.addFlowElementToMap(element);
    }

    @Override
    public void addFlowElementToMap(FlowElement element) {
        if (element != null && StringUtils.isNotEmpty((CharSequence)element.getId())) {
            this.flowElementMap.put(element.getId(), element);
        }
    }

    @Override
    public void removeFlowElement(String elementId) {
        FlowElement element = this.flowElementMap.get(elementId);
        if (element != null) {
            this.flowElementList.remove(element);
            this.flowElementMap.remove(element.getId());
        }
    }

    @Override
    public void removeFlowElementFromMap(String elementId) {
        if (StringUtils.isNotEmpty((CharSequence)elementId)) {
            this.flowElementMap.remove(elementId);
        }
    }

    @Override
    public Artifact getArtifact(String id) {
        Artifact foundArtifact = null;
        for (Artifact artifact : this.artifactList) {
            if (!id.equals(artifact.getId())) continue;
            foundArtifact = artifact;
            break;
        }
        return foundArtifact;
    }

    @Override
    public Collection<Artifact> getArtifacts() {
        return this.artifactList;
    }

    @Override
    public void addArtifact(Artifact artifact) {
        this.artifactList.add(artifact);
    }

    @Override
    public void removeArtifact(String artifactId) {
        Artifact artifact = this.getArtifact(artifactId);
        if (artifact != null) {
            this.artifactList.remove(artifact);
        }
    }

    public List<String> getCandidateStarterUsers() {
        return this.candidateStarterUsers;
    }

    public void setCandidateStarterUsers(List<String> candidateStarterUsers) {
        this.candidateStarterUsers = candidateStarterUsers;
    }

    public List<String> getCandidateStarterGroups() {
        return this.candidateStarterGroups;
    }

    public void setCandidateStarterGroups(List<String> candidateStarterGroups) {
        this.candidateStarterGroups = candidateStarterGroups;
    }

    public List<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public void setEventListeners(List<EventListener> eventListeners) {
        this.eventListeners = eventListeners;
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsOfType(Class<FlowElementType> type) {
        return this.findFlowElementsOfType(type, true);
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsOfType(Class<FlowElementType> type, boolean goIntoSubprocesses) {
        ArrayList<FlowElement> foundFlowElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : this.getFlowElements()) {
            if (type.isInstance(flowElement)) {
                foundFlowElements.add(flowElement);
            }
            if (!(flowElement instanceof SubProcess) || !goIntoSubprocesses) continue;
            foundFlowElements.addAll(this.findFlowElementsInSubProcessOfType((SubProcess)flowElement, type));
        }
        return foundFlowElements;
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsInSubProcessOfType(SubProcess subProcess, Class<FlowElementType> type) {
        return this.findFlowElementsInSubProcessOfType(subProcess, type, true);
    }

    public <FlowElementType extends FlowElement> List<FlowElementType> findFlowElementsInSubProcessOfType(SubProcess subProcess, Class<FlowElementType> type, boolean goIntoSubprocesses) {
        ArrayList<FlowElement> foundFlowElements = new ArrayList<FlowElement>();
        for (FlowElement flowElement : subProcess.getFlowElements()) {
            if (type.isInstance(flowElement)) {
                foundFlowElements.add(flowElement);
            }
            if (!(flowElement instanceof SubProcess) || !goIntoSubprocesses) continue;
            foundFlowElements.addAll(this.findFlowElementsInSubProcessOfType((SubProcess)flowElement, type));
        }
        return foundFlowElements;
    }

    public FlowElementsContainer findParent(FlowElement childElement) {
        return this.findParent(childElement, this);
    }

    public FlowElementsContainer findParent(FlowElement childElement, FlowElementsContainer flowElementsContainer) {
        for (FlowElement flowElement : flowElementsContainer.getFlowElements()) {
            FlowElementsContainer result;
            if (childElement.getId() != null && childElement.getId().equals(flowElement.getId())) {
                return flowElementsContainer;
            }
            if (!(flowElement instanceof FlowElementsContainer) || (result = this.findParent(childElement, (FlowElementsContainer)((Object)flowElement))) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Process clone() {
        Process clone = new Process();
        clone.setValues(this);
        return clone;
    }

    public void setValues(Process otherElement) {
        super.setValues(otherElement);
        this.setName(otherElement.getName());
        this.setExecutable(otherElement.isExecutable());
        this.setDocumentation(otherElement.getDocumentation());
        if (otherElement.getIoSpecification() != null) {
            this.setIoSpecification(otherElement.getIoSpecification().clone());
        }
        this.executionListeners = new ArrayList<FlowableListener>();
        if (otherElement.getExecutionListeners() != null && !otherElement.getExecutionListeners().isEmpty()) {
            for (FlowableListener flowableListener : otherElement.getExecutionListeners()) {
                this.executionListeners.add(flowableListener.clone());
            }
        }
        this.candidateStarterUsers = new ArrayList<String>();
        if (otherElement.getCandidateStarterUsers() != null && !otherElement.getCandidateStarterUsers().isEmpty()) {
            this.candidateStarterUsers.addAll(otherElement.getCandidateStarterUsers());
        }
        this.candidateStarterGroups = new ArrayList<String>();
        if (otherElement.getCandidateStarterGroups() != null && !otherElement.getCandidateStarterGroups().isEmpty()) {
            this.candidateStarterGroups.addAll(otherElement.getCandidateStarterGroups());
        }
        this.enableEagerExecutionTreeFetching = otherElement.enableEagerExecutionTreeFetching;
        this.eventListeners = new ArrayList<EventListener>();
        if (otherElement.getEventListeners() != null && !otherElement.getEventListeners().isEmpty()) {
            for (EventListener eventListener : otherElement.getEventListeners()) {
                this.eventListeners.add(eventListener.clone());
            }
        }
        for (ValuedDataObject valuedDataObject : this.getDataObjects()) {
            boolean exists = false;
            for (ValuedDataObject otherObject : otherElement.getDataObjects()) {
                if (!valuedDataObject.getId().equals(otherObject.getId())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.removeFlowElement(valuedDataObject.getId());
        }
        this.dataObjects = new ArrayList<ValuedDataObject>();
        if (otherElement.getDataObjects() != null && !otherElement.getDataObjects().isEmpty()) {
            for (ValuedDataObject valuedDataObject : otherElement.getDataObjects()) {
                ValuedDataObject clone = valuedDataObject.clone();
                this.dataObjects.add(clone);
                this.removeFlowElement(clone.getId());
                this.addFlowElement(clone);
            }
        }
    }

    public List<ValuedDataObject> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(List<ValuedDataObject> dataObjects) {
        this.dataObjects = dataObjects;
    }

    public FlowElement getInitialFlowElement() {
        return this.initialFlowElement;
    }

    public void setInitialFlowElement(FlowElement initialFlowElement) {
        this.initialFlowElement = initialFlowElement;
    }

    public boolean isEnableEagerExecutionTreeFetching() {
        return this.enableEagerExecutionTreeFetching;
    }

    public void setEnableEagerExecutionTreeFetching(boolean enableEagerExecutionTreeFetching) {
        this.enableEagerExecutionTreeFetching = enableEagerExecutionTreeFetching;
    }
}

